/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.channel.ShardPosition;
import de.otto.synapse.message.TextMessage;
import de.otto.synapse.messagestore.WritableMessageStore;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class InMemoryRingBufferMessageStore
implements WritableMessageStore {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Queue<TextMessage> messages;
    private final AtomicReference<ChannelPosition> latestChannelPosition = new AtomicReference<ChannelPosition>(ChannelPosition.fromHorizon());

    public InMemoryRingBufferMessageStore() {
        this.messages = EvictingQueue.create((int)100);
    }

    public InMemoryRingBufferMessageStore(int capacity) {
        this.messages = EvictingQueue.create((int)capacity);
    }

    @Override
    public synchronized void add(TextMessage message) {
        this.lock.writeLock().lock();
        try {
            this.messages.add(message);
            this.latestChannelPosition.updateAndGet(previous -> {
                Optional<ShardPosition> optionalMessagePosition = message.getHeader().getShardPosition();
                return optionalMessagePosition.map(messagePosition -> ChannelPosition.merge(previous, ChannelPosition.channelPosition(messagePosition))).orElse((ChannelPosition)previous);
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public synchronized ChannelPosition getLatestChannelPosition() {
        this.lock.readLock().lock();
        try {
            ChannelPosition channelPosition = this.latestChannelPosition.get();
            return channelPosition;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public synchronized Stream<TextMessage> stream() {
        this.lock.readLock().lock();
        try {
            Stream stream = ImmutableList.copyOf(this.messages).stream();
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public synchronized int size() {
        return this.messages.size();
    }
}

