/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore;

import com.google.common.collect.ImmutableSet;
import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.messagestore.InMemoryChannelPositions;
import de.otto.synapse.messagestore.Index;
import de.otto.synapse.messagestore.Indexer;
import de.otto.synapse.messagestore.Indexers;
import de.otto.synapse.messagestore.MessageStore;
import de.otto.synapse.messagestore.MessageStoreEntry;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CompactingInMemoryMessageStore
implements MessageStore {
    private final String name;
    private final boolean removeNullPayloadMessages;
    private final Indexer indexer;
    private final InMemoryChannelPositions channelPositions = new InMemoryChannelPositions();
    private final ConcurrentNavigableMap<String, MessageStoreEntry> entries = new ConcurrentSkipListMap<String, MessageStoreEntry>();
    private final ConcurrentMap<String, ConcurrentNavigableMap<String, MessageStoreEntry>> indexes = new ConcurrentHashMap<String, ConcurrentNavigableMap<String, MessageStoreEntry>>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public CompactingInMemoryMessageStore(String name, boolean removeNullPayloadMessages) {
        this.removeNullPayloadMessages = removeNullPayloadMessages;
        this.name = name;
        this.indexer = Indexers.noOpIndexer();
    }

    public CompactingInMemoryMessageStore(String name, boolean removeNullPayloadMessages, Indexer indexer) {
        this.removeNullPayloadMessages = removeNullPayloadMessages;
        this.name = name;
        this.indexer = indexer;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(MessageStoreEntry entry) {
        this.lock.writeLock().lock();
        try {
            MessageStoreEntry indexedEntry = this.indexer.index(entry);
            String internalKey = entry.getChannelName() + ":" + entry.getTextMessage().getKey().compactionKey();
            if (entry.getTextMessage().getPayload() == null && this.removeNullPayloadMessages) {
                this.entries.remove(internalKey);
                indexedEntry.getFilterValues().forEach((key, value) -> {
                    String indexKey = this.indexKeyOf((Index)key, (String)value);
                    if (this.indexes.containsKey(indexKey)) {
                        ((ConcurrentNavigableMap)this.indexes.get(indexKey)).remove(internalKey);
                    }
                });
            } else {
                this.entries.put(internalKey, indexedEntry);
                indexedEntry.getFilterValues().forEach((key, value) -> {
                    String indexKey = this.indexKeyOf((Index)key, (String)value);
                    if (!this.indexes.containsKey(indexKey)) {
                        this.indexes.put(indexKey, new ConcurrentSkipListMap());
                    }
                    ((ConcurrentNavigableMap)this.indexes.get(indexKey)).put(internalKey, indexedEntry);
                });
            }
            this.channelPositions.updateFrom(indexedEntry);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Set<String> getChannelNames() {
        this.lock.readLock().lock();
        try {
            ImmutableSet<String> immutableSet = this.channelPositions.channelNames();
            return immutableSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ImmutableSet<Index> getIndexes() {
        return this.indexer.getIndexes();
    }

    @Override
    public ChannelPosition getLatestChannelPosition(String channelName) {
        this.lock.readLock().lock();
        try {
            ChannelPosition channelPosition = this.channelPositions.positionOf(channelName);
            return channelPosition;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Stream<MessageStoreEntry> stream() {
        this.lock.readLock().lock();
        try {
            Stream<MessageStoreEntry> stream = this.entries.values().stream();
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Stream<MessageStoreEntry> stream(Index index, String value) {
        String indexKey = this.indexKeyOf(index, value);
        if (this.indexes.containsKey(indexKey)) {
            return ((ConcurrentNavigableMap)this.indexes.get(indexKey)).values().stream();
        }
        return Stream.empty();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    private String indexKeyOf(Index index, String value) {
        return index.getName() + "#" + value;
    }
}

