/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableSet;
import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.messagestore.InMemoryChannelPositions;
import de.otto.synapse.messagestore.Index;
import de.otto.synapse.messagestore.MessageStore;
import de.otto.synapse.messagestore.MessageStoreEntry;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class InMemoryRingBufferMessageStore
implements MessageStore {
    private final String name;
    private final Queue<MessageStoreEntry> entries;
    private final InMemoryChannelPositions channelPositions = new InMemoryChannelPositions();

    public InMemoryRingBufferMessageStore(String name) {
        this.name = name;
        this.entries = EvictingQueue.create((int)100);
    }

    public InMemoryRingBufferMessageStore(String name, int capacity) {
        this.name = name;
        this.entries = EvictingQueue.create((int)capacity);
    }

    @Override
    public synchronized void add(MessageStoreEntry entry) {
        this.entries.add(entry);
        this.channelPositions.updateFrom(entry);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized Set<String> getChannelNames() {
        return this.channelPositions.channelNames();
    }

    @Override
    public ImmutableSet<Index> getIndexes() {
        return ImmutableSet.of();
    }

    @Override
    public synchronized ChannelPosition getLatestChannelPosition(String channelName) {
        return this.channelPositions.positionOf(channelName);
    }

    @Override
    public synchronized Stream<MessageStoreEntry> stream() {
        return this.entries.stream();
    }

    @Override
    public Stream<MessageStoreEntry> stream(Index index, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized int size() {
        return this.entries.size();
    }
}

