/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.messagestore.Index;
import de.otto.synapse.messagestore.MessageStoreEntry;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public interface MessageStore
extends AutoCloseable {
    public String getName();

    public Set<String> getChannelNames();

    public ImmutableSet<Index> getIndexes();

    public ChannelPosition getLatestChannelPosition(String var1);

    @Deprecated
    default public ChannelPosition getLatestChannelPosition() {
        if (this.getChannelNames().size() > 1) {
            throw new IllegalStateException("Deprecated method getLatestChannelPosition() called on a MessageStore containing messages from several channels: " + this.getChannelNames());
        }
        String channelName = (String)Iterables.getFirst(this.getChannelNames(), (Object)"");
        return this.getLatestChannelPosition(channelName);
    }

    public Stream<MessageStoreEntry> stream();

    @Beta
    public Stream<MessageStoreEntry> stream(Index var1, String var2);

    public void add(@Nonnull MessageStoreEntry var1);

    default public int size() {
        return -1;
    }

    @Override
    default public void close() {
    }
}

