/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore;

import com.google.common.collect.ImmutableSet;
import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.messagestore.InMemoryChannelPositions;
import de.otto.synapse.messagestore.Index;
import de.otto.synapse.messagestore.Indexer;
import de.otto.synapse.messagestore.Indexers;
import de.otto.synapse.messagestore.MessageStore;
import de.otto.synapse.messagestore.MessageStoreEntry;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CompactingConcurrentMapMessageStore
implements MessageStore {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ConcurrentSkipListSet<String> compactedAndOrderedKeys = new ConcurrentSkipListSet();
    private final ConcurrentMap<String, MessageStoreEntry> entries;
    private final ConcurrentMap<String, ConcurrentSkipListSet<String>> indexes = new ConcurrentHashMap<String, ConcurrentSkipListSet<String>>();
    private final InMemoryChannelPositions channelPositions = new InMemoryChannelPositions();
    private final boolean removeNullPayloadMessages;
    private final Indexer indexer;
    private final String name;

    public CompactingConcurrentMapMessageStore(String name, boolean removeNullPayloadMessages, ConcurrentMap<String, MessageStoreEntry> messageMap) {
        this(name, removeNullPayloadMessages, messageMap, Indexers.noOpIndexer());
    }

    public CompactingConcurrentMapMessageStore(String name, boolean removeNullPayloadMessages, ConcurrentMap<String, MessageStoreEntry> messageMap, Indexer indexer) {
        this.name = name;
        this.entries = messageMap;
        this.removeNullPayloadMessages = removeNullPayloadMessages;
        this.indexer = indexer;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(MessageStoreEntry entry) {
        String messageKey = entry.getChannelName() + ":" + entry.getTextMessage().getKey().compactionKey();
        this.lock.writeLock().lock();
        try {
            MessageStoreEntry indexedEntry = this.indexer.index(entry);
            if (entry.getTextMessage().getPayload() == null && this.removeNullPayloadMessages) {
                this.entries.remove(messageKey);
                this.compactedAndOrderedKeys.remove(messageKey);
                indexedEntry.getFilterValues().forEach((key, value) -> {
                    String indexKey = this.indexKeyOf((Index)key, (String)value);
                    if (this.indexes.containsKey(indexKey)) {
                        ((ConcurrentSkipListSet)this.indexes.get(indexKey)).remove(messageKey);
                    }
                });
            } else {
                this.entries.put(messageKey, indexedEntry);
                this.compactedAndOrderedKeys.add(messageKey);
                indexedEntry.getFilterValues().forEach((key, value) -> {
                    String indexKey = this.indexKeyOf((Index)key, (String)value);
                    if (!this.indexes.containsKey(indexKey)) {
                        this.indexes.put(indexKey, new ConcurrentSkipListSet());
                    }
                    ((ConcurrentSkipListSet)this.indexes.get(indexKey)).add(messageKey);
                });
            }
            this.channelPositions.updateFrom(entry);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Set<String> getChannelNames() {
        this.lock.readLock().lock();
        try {
            ImmutableSet<String> immutableSet = this.channelPositions.channelNames();
            return immutableSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ImmutableSet<Index> getIndexes() {
        return this.indexer.getIndexes();
    }

    @Override
    public ChannelPosition getLatestChannelPosition(String channelName) {
        this.lock.readLock().lock();
        try {
            ChannelPosition channelPosition = this.channelPositions.positionOf(channelName);
            return channelPosition;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Stream<MessageStoreEntry> stream() {
        this.lock.readLock().lock();
        try {
            Stream<MessageStoreEntry> stream = this.compactedAndOrderedKeys.stream().map(this.entries::get);
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Stream<MessageStoreEntry> stream(Index index, String value) {
        String indexKey = this.indexKeyOf(index, value);
        if (this.indexes.containsKey(indexKey)) {
            return ((ConcurrentSkipListSet)this.indexes.get(indexKey)).stream().map(this.entries::get);
        }
        return Stream.empty();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    private String indexKeyOf(Index index, String value) {
        return index.getName() + "#" + value;
    }
}

