/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.configuration;

import de.otto.synapse.annotation.EventSourceConsumerBeanPostProcessor;
import de.otto.synapse.configuration.SynapseAutoConfiguration;
import de.otto.synapse.configuration.SynapseProperties;
import de.otto.synapse.eventsource.DefaultEventSource;
import de.otto.synapse.eventsource.EventSource;
import de.otto.synapse.eventsource.EventSourceBuilder;
import de.otto.synapse.eventsource.EventSourceConsumerProcess;
import de.otto.synapse.messagestore.MessageStoreFactory;
import de.otto.synapse.messagestore.SnapshotMessageStore;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Role;

@Import(value={SynapseAutoConfiguration.class})
@EnableConfigurationProperties(value={SynapseProperties.class})
public class EventSourcingAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(EventSourcingAutoConfiguration.class);
    @Autowired(required=false)
    private List<EventSource> eventSources;

    @Bean
    @ConditionalOnMissingBean
    public EventSourceBuilder eventSourceBuilder(MessageStoreFactory<SnapshotMessageStore> snapshotMessageStoreFactory) {
        return messageLog -> {
            SnapshotMessageStore messageStore = (SnapshotMessageStore)snapshotMessageStoreFactory.createMessageStoreFor("snapshot", messageLog.getChannelName());
            return new DefaultEventSource(messageStore, messageLog);
        };
    }

    @Bean
    @ConditionalOnProperty(prefix="synapse", name={"consumer-process.enabled"}, havingValue="true", matchIfMissing=true)
    public EventSourceConsumerProcess eventSourceConsumerProcess() {
        return new EventSourceConsumerProcess(this.eventSources);
    }

    @Bean
    @Role(value=2)
    public EventSourceConsumerBeanPostProcessor eventSourceConsumerAnnotationBeanPostProcessor() {
        return new EventSourceConsumerBeanPostProcessor();
    }
}

