/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint;

import de.otto.synapse.annotation.MessageInterceptor;
import de.otto.synapse.configuration.SynapseProperties;
import de.otto.synapse.endpoint.EndpointType;
import de.otto.synapse.message.DefaultHeaderAttr;
import de.otto.synapse.message.Header;
import de.otto.synapse.message.HeaderAttr;
import de.otto.synapse.message.TextMessage;
import java.time.Clock;
import java.util.EnumSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultSenderHeadersInterceptor {
    private final Set<Capability> capabilities;
    private final String senderName;
    private final Clock clock;

    public DefaultSenderHeadersInterceptor(SynapseProperties synapseProperties) {
        this(synapseProperties, EnumSet.allOf(Capability.class), Clock.systemDefaultZone());
    }

    public DefaultSenderHeadersInterceptor(SynapseProperties synapseProperties, Set<Capability> capabilities, Clock clock) {
        this.senderName = synapseProperties.getSender().getName();
        this.capabilities = synapseProperties.getSender().getDefaultHeaders().isEnabled() ? capabilities : EnumSet.noneOf(Capability.class);
        this.clock = clock;
    }

    @Nullable
    @MessageInterceptor(endpointType={EndpointType.SENDER})
    public TextMessage addDefaultHeaders(@Nonnull TextMessage message) {
        Header.Builder headers = Header.copyOf(message.getHeader());
        if (this.capabilities.contains((Object)Capability.SENDER_NAME)) {
            headers.withAttribute((HeaderAttr)DefaultHeaderAttr.MSG_SENDER, this.senderName);
        }
        if (this.capabilities.contains((Object)Capability.MESSAGE_ID)) {
            headers.withAttribute((HeaderAttr)DefaultHeaderAttr.MSG_ID, UUID.randomUUID().toString());
        }
        if (this.capabilities.contains((Object)Capability.TIMESTAMP)) {
            headers.withAttribute((HeaderAttr)DefaultHeaderAttr.MSG_SENDER_TS, this.clock.instant());
        }
        return TextMessage.of(message.getKey(), headers.build(), (String)message.getPayload());
    }

    public static enum Capability {
        SENDER_NAME,
        MESSAGE_ID,
        TIMESTAMP;

    }
}

