/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore;

import com.google.common.collect.ImmutableSet;
import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.channel.ShardPosition;
import de.otto.synapse.messagestore.MessageStoreEntry;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class InMemoryChannelPositions {
    private final ConcurrentMap<String, ChannelPosition> channelPositions = new ConcurrentHashMap<String, ChannelPosition>();

    InMemoryChannelPositions() {
    }

    void updateFrom(MessageStoreEntry entry) {
        this.channelPositions.compute(entry.getChannelName(), (key, existing) -> {
            Optional<ShardPosition> shardPosition = entry.getTextMessage().getHeader().getShardPosition();
            if (existing != null) {
                return shardPosition.map(s -> ChannelPosition.merge(existing, ChannelPosition.channelPosition(s))).orElse((ChannelPosition)existing);
            }
            return shardPosition.map(xva$0 -> ChannelPosition.channelPosition(xva$0)).orElseGet(ChannelPosition::fromHorizon);
        });
    }

    public ImmutableSet<String> channelNames() {
        return ImmutableSet.copyOf(this.channelPositions.keySet());
    }

    public ChannelPosition positionOf(String channelName) {
        return this.channelPositions.getOrDefault(channelName, ChannelPosition.fromHorizon());
    }
}

