/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.eventsource;

import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.channel.ShardResponse;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpoint;
import de.otto.synapse.eventsource.AbstractEventSource;
import de.otto.synapse.message.TextMessage;
import de.otto.synapse.messagestore.MessageStore;
import de.otto.synapse.messagestore.MessageStoreEntry;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class DefaultEventSource
extends AbstractEventSource {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEventSource.class);
    private final MessageStore messageStore;

    public DefaultEventSource(@Nonnull MessageStore messageStore, @Nonnull MessageLogReceiverEndpoint messageLog) {
        super(messageLog);
        this.messageStore = messageStore;
    }

    @Override
    @Nonnull
    public CompletableFuture<ChannelPosition> consumeUntil(@Nonnull Predicate<ShardResponse> stopCondition) {
        return ((CompletableFuture)this.consumeMessageStore().thenCompose(channelPosition -> this.getMessageLogReceiverEndpoint().consumeUntil((ChannelPosition)channelPosition, stopCondition))).handle((channelPosition, throwable) -> {
            if (throwable != null) {
                LOG.error("Failed to start consuming from EventSource {}: {}. Closing MessageStore.", new Object[]{this.getChannelName(), throwable.getMessage(), throwable});
            }
            try {
                this.messageStore.close();
            }
            catch (Exception e) {
                LOG.error("Unable to close() MessageStore: " + e.getMessage(), (Throwable)e);
            }
            return channelPosition;
        });
    }

    private CompletableFuture<ChannelPosition> consumeMessageStore() {
        int numberOfDispatcherThreads = 1;
        if (this.messageStore.isCompacting()) {
            numberOfDispatcherThreads = Runtime.getRuntime().availableProcessors();
        }
        ExecutorService executorService = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory("synapse-messagestore-dispatcher-"));
        Semaphore lock = new Semaphore(numberOfDispatcherThreads);
        String channelName = this.getChannelName();
        LOG.info("Starting to read message store for channel '{}'.", (Object)channelName);
        Instant startTime = Instant.now();
        AtomicLong messageCounter = new AtomicLong();
        return CompletableFuture.supplyAsync(() -> {
            this.messageStore.stream().filter(entry -> entry.getChannelName().equals(channelName)).map(MessageStoreEntry::getTextMessage).map(message -> this.getMessageLogReceiverEndpoint().intercept((TextMessage)message)).filter(Objects::nonNull).forEach(message -> {
                try {
                    lock.acquire();
                }
                catch (InterruptedException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                executorService.execute(() -> {
                    try {
                        this.getMessageLogReceiverEndpoint().getMessageDispatcher().accept((TextMessage)message);
                    }
                    finally {
                        long counter = messageCounter.getAndIncrement();
                        if (counter % 100000L == 0L) {
                            LOG.info("Consumed {} messages from message store for channel '{}'", (Object)counter, (Object)channelName);
                        }
                        lock.release();
                    }
                });
            });
            executorService.shutdown();
            try {
                executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
                LOG.info("Consumed {} messages from message store for channel '{}'", (Object)messageCounter.get(), (Object)channelName);
            }
            catch (InterruptedException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            LOG.info("Finished reading message store for channel '{}'. Duration was {}.", (Object)channelName, (Object)Duration.between(startTime, Instant.now()));
            return this.messageStore.getLatestChannelPosition(channelName);
        }, Executors.newSingleThreadExecutor((ThreadFactory)new CustomizableThreadFactory("synapse-eventsource-")));
    }
}

