/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.receiver;

import de.otto.synapse.endpoint.receiver.MessageQueueReceiverEndpoint;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.SmartLifecycle;

public class MessageQueueConsumerProcess
implements SmartLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(MessageQueueConsumerProcess.class);
    private static final String THREAD_NAME_PREFIX = "synapse-consumer-";
    private final List<MessageQueueReceiverEndpoint> messageQueueReceiverEndpoints;
    private volatile boolean running = false;

    public MessageQueueConsumerProcess(List<MessageQueueReceiverEndpoint> messageQueueReceiverEndpoints) {
        this.messageQueueReceiverEndpoints = messageQueueReceiverEndpoints;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public int getPhase() {
        return 0;
    }

    public void start() {
        int receiverCount;
        int n = receiverCount = this.messageQueueReceiverEndpoints != null ? this.messageQueueReceiverEndpoints.size() : 0;
        if (receiverCount > 0) {
            LOG.info("Initializing MessageQueueConsumerProcess with {} MessageQueues", (Object)receiverCount);
            this.running = true;
            this.messageQueueReceiverEndpoints.forEach(endpoint -> {
                try {
                    LOG.info("Starting {}...", (Object)endpoint.getChannelName());
                    endpoint.consume();
                }
                catch (Exception e) {
                    LOG.error("Starting failed: " + e.getMessage(), (Throwable)e);
                    this.stop();
                }
            });
        } else {
            LOG.warn("Did not find any MessageQueue instances to execute");
            this.running = false;
        }
    }

    public void stop() {
        LOG.info("Shutting down...");
        this.messageQueueReceiverEndpoints.forEach(MessageQueueReceiverEndpoint::stop);
        this.running = false;
        LOG.info("...done.");
    }

    public boolean isRunning() {
        return this.running;
    }
}

