/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.state;

import de.otto.synapse.state.StateRepository;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentMapStateRepository<V>
implements StateRepository<V> {
    private static final Logger LOG = LoggerFactory.getLogger(ConcurrentMapStateRepository.class);
    private final String name;
    private final ConcurrentMap<String, V> concurrentMap;

    public ConcurrentMapStateRepository(String name) {
        this(name, new ConcurrentHashMap());
    }

    public ConcurrentMapStateRepository(String name, ConcurrentMap<String, V> map) {
        this.name = Objects.requireNonNull(name, "Parameter 'name' must not be null");
        this.concurrentMap = Objects.requireNonNull(map, "Parameter 'map' must not be null");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<V> compute(String key, BiFunction<? super String, ? super Optional<V>, ? extends V> remappingFunction) {
        return Optional.ofNullable(this.concurrentMap.compute(key, (? super K k, ? super V v) -> remappingFunction.apply((String)k, (Object)Optional.ofNullable(v))));
    }

    @Override
    public void consumeAll(BiConsumer<? super String, ? super V> consumer) {
        this.concurrentMap.forEach(consumer);
    }

    @Override
    public Optional<V> put(String key, V value) {
        return Optional.ofNullable(this.concurrentMap.put(key, value));
    }

    @Override
    public Optional<V> remove(String key) {
        return Optional.ofNullable(this.concurrentMap.remove(key));
    }

    @Override
    public void clear() {
        this.concurrentMap.clear();
    }

    @Override
    public Optional<V> get(String key) {
        return Optional.ofNullable(this.concurrentMap.get(key));
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.concurrentMap.keySet());
    }

    @Override
    public long size() {
        return this.concurrentMap.size();
    }

    @Override
    public void close() throws Exception {
        LOG.info("Closing StateRepository.");
        if (this.concurrentMap instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.concurrentMap)).close();
        }
    }
}

