/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.eventsource;

import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.channel.ShardResponse;
import de.otto.synapse.consumer.MessageConsumer;
import de.otto.synapse.consumer.MessageDispatcher;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpoint;
import de.otto.synapse.eventsource.EventSource;
import de.otto.synapse.eventsource.EventSourceBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.springframework.context.ApplicationContext;

public class DelegateEventSource
implements EventSource {
    private final EventSource delegate;

    public DelegateEventSource(String messageLogBeanName, EventSourceBuilder eventSourceBuilder, ApplicationContext applicationContext) {
        MessageLogReceiverEndpoint messageLogReceiverEndpoint = (MessageLogReceiverEndpoint)applicationContext.getBean(messageLogBeanName, MessageLogReceiverEndpoint.class);
        this.delegate = eventSourceBuilder.buildEventSource(messageLogReceiverEndpoint);
    }

    public EventSource getDelegate() {
        return this.delegate;
    }

    @Override
    public void register(MessageConsumer<?> messageConsumer) {
        this.delegate.register(messageConsumer);
    }

    @Override
    @Nonnull
    public MessageDispatcher getMessageDispatcher() {
        return this.delegate.getMessageDispatcher();
    }

    @Override
    @Nonnull
    public MessageLogReceiverEndpoint getMessageLogReceiverEndpoint() {
        return this.delegate.getMessageLogReceiverEndpoint();
    }

    @Override
    @Nonnull
    public String getChannelName() {
        return this.delegate.getChannelName();
    }

    @Override
    public CompletableFuture<ChannelPosition> consume() {
        return this.delegate.consume();
    }

    @Override
    @Nonnull
    public CompletableFuture<ChannelPosition> consumeUntil(@Nonnull Predicate<ShardResponse> stopCondition) {
        return this.delegate.consumeUntil(stopCondition);
    }

    @Override
    public void stop() {
        this.delegate.stop();
    }

    @Override
    public boolean isStopping() {
        return this.delegate.isStopping();
    }

    public String toString() {
        return "DelegateEventSource{delegate=" + this.delegate + "}";
    }
}

