/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.annotation;

import com.google.common.base.Strings;
import de.otto.synapse.annotation.BeanNameHelper;
import de.otto.synapse.annotation.EnableEventSource;
import de.otto.synapse.annotation.EnableEventSources;
import de.otto.synapse.endpoint.receiver.DelegateMessageLogReceiverEndpoint;
import de.otto.synapse.eventsource.DelegateEventSource;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.MultiValueMap;

public class EventSourceBeanRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private static final Logger LOG = LoggerFactory.getLogger(EventSourceBeanRegistrar.class);
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        MultiValueMap eventSourcesAttr = metadata.getAllAnnotationAttributes(EnableEventSources.class.getName(), false);
        if (eventSourcesAttr != null) {
            Object value = eventSourcesAttr.getFirst((Object)"value");
            if (value == null) {
                return;
            }
            LinkedHashMap[] castedValue = (LinkedHashMap[])value;
            AnnotationAttributes[] attributes = new AnnotationAttributes[castedValue.length];
            for (int i = 0; i < castedValue.length; ++i) {
                attributes[i] = new AnnotationAttributes((Map)castedValue[i]);
            }
            this.registerMultipleEventSources(registry, attributes);
        } else {
            MultiValueMap eventSourceAttr = metadata.getAllAnnotationAttributes(EnableEventSource.class.getName(), false);
            this.registerSingleEventSource(registry, (MultiValueMap<String, Object>)eventSourceAttr);
        }
    }

    private void registerMultipleEventSources(BeanDefinitionRegistry registry, AnnotationAttributes[] annotationAttributesArr) {
        for (AnnotationAttributes annotationAttributes : annotationAttributesArr) {
            String channelName = this.environment.resolvePlaceholders(annotationAttributes.getString("channelName"));
            String eventSourceBeanName = Objects.toString(Strings.emptyToNull((String)annotationAttributes.getString("name")), BeanNameHelper.beanNameForEventSource(channelName));
            String messageLogBeanName = Objects.toString(Strings.emptyToNull((String)annotationAttributes.getString("messageLogReceiverEndpoint")), BeanNameHelper.beanNameForMessageLogReceiverEndpoint(channelName));
            this.registerBeans(registry, channelName, eventSourceBeanName, messageLogBeanName);
        }
    }

    private void registerSingleEventSource(BeanDefinitionRegistry registry, MultiValueMap<String, Object> eventSourceAttr) {
        if (eventSourceAttr != null) {
            String channelName = this.environment.resolvePlaceholders(eventSourceAttr.getFirst((Object)"channelName").toString());
            String eventSourceBeanName = Objects.toString(Strings.emptyToNull((String)eventSourceAttr.getFirst((Object)"name").toString()), BeanNameHelper.beanNameForEventSource(channelName));
            String messageLogBeanName = Objects.toString(Strings.emptyToNull((String)eventSourceAttr.getFirst((Object)"messageLogReceiverEndpoint").toString()), BeanNameHelper.beanNameForMessageLogReceiverEndpoint(channelName));
            this.registerBeans(registry, channelName, eventSourceBeanName, messageLogBeanName);
        }
    }

    private void registerBeans(BeanDefinitionRegistry registry, String channelName, String eventSourceBeanName, String messageLogBeanName) {
        if (registry.containsBeanDefinition(messageLogBeanName)) {
            throw new BeanCreationException(messageLogBeanName, String.format("MessageLogReceiverEndpoint %s is already registered.", messageLogBeanName));
        }
        this.registerMessageLogBeanDefinition(registry, messageLogBeanName, channelName);
        if (registry.containsBeanDefinition(eventSourceBeanName)) {
            throw new BeanCreationException(eventSourceBeanName, String.format("EventSource %s is already registered.", eventSourceBeanName));
        }
        this.registerEventSourceBeanDefinition(registry, eventSourceBeanName, messageLogBeanName, channelName);
    }

    private void registerMessageLogBeanDefinition(BeanDefinitionRegistry registry, String beanName, String channelName) {
        registry.registerBeanDefinition(beanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(DelegateMessageLogReceiverEndpoint.class).addConstructorArgValue((Object)channelName).setDependencyCheck(3).getBeanDefinition());
        LOG.info("Registered MessageLogReceiverEndpoint {} with for channelName {}", (Object)beanName, (Object)channelName);
    }

    private void registerEventSourceBeanDefinition(BeanDefinitionRegistry registry, String beanName, String messageLogBeanName, String channelName) {
        registry.registerBeanDefinition(beanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(DelegateEventSource.class).addConstructorArgValue((Object)messageLogBeanName).setDependencyCheck(3).getBeanDefinition());
        LOG.info("Registered EventSource {} with for channelName {}", (Object)beanName, (Object)channelName);
    }
}

