/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.annotation;

import com.google.common.base.Strings;
import de.otto.synapse.annotation.BeanNameHelper;
import de.otto.synapse.annotation.EnableMessageQueueReceiverEndpoint;
import de.otto.synapse.annotation.EnableMessageQueueReceiverEndpoints;
import de.otto.synapse.endpoint.receiver.DelegateMessageQueueReceiverEndpoint;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.MultiValueMap;

public class MessageQueueReceiverEndpointBeanRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private static final Logger LOG = LoggerFactory.getLogger(MessageQueueReceiverEndpointBeanRegistrar.class);
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        MultiValueMap messageQueuesAttr = metadata.getAllAnnotationAttributes(EnableMessageQueueReceiverEndpoints.class.getName(), false);
        if (messageQueuesAttr != null) {
            Object value = messageQueuesAttr.getFirst((Object)"value");
            if (value == null) {
                return;
            }
            LinkedHashMap[] castedValue = (LinkedHashMap[])value;
            AnnotationAttributes[] attributes = new AnnotationAttributes[castedValue.length];
            for (int i = 0; i < castedValue.length; ++i) {
                attributes[i] = new AnnotationAttributes((Map)castedValue[i]);
            }
            this.registerMultipleMessageQueueReceiverEndpoints(registry, attributes);
        } else {
            MultiValueMap messageQueueAttr = metadata.getAllAnnotationAttributes(EnableMessageQueueReceiverEndpoint.class.getName(), false);
            this.registerSingleMessageQueue(registry, (MultiValueMap<String, Object>)messageQueueAttr);
        }
    }

    private void registerMultipleMessageQueueReceiverEndpoints(BeanDefinitionRegistry registry, AnnotationAttributes[] annotationAttributesArr) {
        for (AnnotationAttributes annotationAttributes : annotationAttributesArr) {
            String channelName = this.environment.resolvePlaceholders(annotationAttributes.getString("channelName"));
            String messageQueueReceiverEndpointBeanName = Objects.toString(Strings.emptyToNull((String)annotationAttributes.getString("name")), BeanNameHelper.beanNameForMessageQueueReceiverEndpoint(channelName));
            if (registry.containsBeanDefinition(messageQueueReceiverEndpointBeanName)) {
                throw new BeanCreationException(messageQueueReceiverEndpointBeanName, String.format("messageQueueReceiverEndpoint %s is already registered.", messageQueueReceiverEndpointBeanName));
            }
            this.registerMessageQueueReceiverEndpointBeanDefinition(registry, messageQueueReceiverEndpointBeanName, channelName);
        }
    }

    private void registerSingleMessageQueue(BeanDefinitionRegistry registry, MultiValueMap<String, Object> messageQueueAttr) {
        if (messageQueueAttr != null) {
            String channelName = this.environment.resolvePlaceholders(messageQueueAttr.getFirst((Object)"channelName").toString());
            String messageQueueReceiverEndpointBeanName = Objects.toString(Strings.emptyToNull((String)messageQueueAttr.getFirst((Object)"name").toString()), BeanNameHelper.beanNameForMessageQueueReceiverEndpoint(channelName));
            if (!registry.containsBeanDefinition(messageQueueReceiverEndpointBeanName)) {
                this.registerMessageQueueReceiverEndpointBeanDefinition(registry, messageQueueReceiverEndpointBeanName, channelName);
            } else {
                throw new BeanCreationException(messageQueueReceiverEndpointBeanName, String.format("MessageQueueReceiverEndpoint %s is already registered.", messageQueueReceiverEndpointBeanName));
            }
        }
    }

    private void registerMessageQueueReceiverEndpointBeanDefinition(BeanDefinitionRegistry registry, String beanName, String channelName) {
        registry.registerBeanDefinition(beanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(DelegateMessageQueueReceiverEndpoint.class).addConstructorArgValue((Object)channelName).setDependencyCheck(3).getBeanDefinition());
        LOG.info("Registered MessageQueueReceiverEndpoint {} with for channelName {}", (Object)beanName, (Object)channelName);
    }
}

