/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.annotation;

import com.google.common.base.Strings;
import de.otto.synapse.annotation.BeanNameHelper;
import de.otto.synapse.annotation.EnableMessageSenderEndpoint;
import de.otto.synapse.annotation.EnableMessageSenderEndpoints;
import de.otto.synapse.channel.selector.Selector;
import de.otto.synapse.endpoint.sender.DelegateMessageSenderEndpoint;
import de.otto.synapse.translator.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.MultiValueMap;

public class MessageSenderEndpointBeanRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private static final Logger LOG = LoggerFactory.getLogger(MessageSenderEndpointBeanRegistrar.class);
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        MultiValueMap messageQueuesAttr = metadata.getAllAnnotationAttributes(EnableMessageSenderEndpoints.class.getName(), false);
        if (messageQueuesAttr != null) {
            Object value = messageQueuesAttr.getFirst((Object)"value");
            if (value == null) {
                return;
            }
            LinkedHashMap[] castedValue = (LinkedHashMap[])value;
            AnnotationAttributes[] attributes = new AnnotationAttributes[castedValue.length];
            for (int i = 0; i < castedValue.length; ++i) {
                attributes[i] = new AnnotationAttributes((Map)castedValue[i]);
            }
            this.registerMultipleMessageQueueSenderEndpoints(registry, attributes);
        } else {
            MultiValueMap messageQueueAttr = metadata.getAllAnnotationAttributes(EnableMessageSenderEndpoint.class.getName(), false);
            this.registerSingleMessageQueueSenderEndpoint(registry, (MultiValueMap<String, Object>)messageQueueAttr);
        }
    }

    private void registerMultipleMessageQueueSenderEndpoints(BeanDefinitionRegistry registry, AnnotationAttributes[] annotationAttributesArr) {
        for (AnnotationAttributes annotationAttributes : annotationAttributesArr) {
            String channelName = this.environment.resolvePlaceholders(annotationAttributes.getString("channelName"));
            Class selector = annotationAttributes.getClass("selector");
            String messageQueueSenderEndpointBeanName = Objects.toString(Strings.emptyToNull((String)annotationAttributes.getString("name")), BeanNameHelper.beanNameForMessageSenderEndpoint(channelName));
            MessageFormat messageFormat = (MessageFormat)annotationAttributes.getEnum("messageFormat");
            if (registry.containsBeanDefinition(messageQueueSenderEndpointBeanName)) {
                throw new BeanCreationException(messageQueueSenderEndpointBeanName, String.format("messageQueueSenderEndpoint %s is already registered.", messageQueueSenderEndpointBeanName));
            }
            this.registerMessageQueueSenderEndpointBeanDefinition(registry, messageQueueSenderEndpointBeanName, channelName, messageFormat, selector);
        }
    }

    private void registerSingleMessageQueueSenderEndpoint(BeanDefinitionRegistry registry, MultiValueMap<String, Object> messageQueueAttr) {
        if (messageQueueAttr != null) {
            String channelName = this.environment.resolvePlaceholders(messageQueueAttr.getFirst((Object)"channelName").toString());
            MessageFormat messageFormat = MessageFormat.valueOf(messageQueueAttr.getFirst((Object)"messageFormat").toString());
            String messageSenderEndpointBeanName = Objects.toString(Strings.emptyToNull((String)messageQueueAttr.getFirst((Object)"name").toString()), BeanNameHelper.beanNameForMessageSenderEndpoint(channelName));
            Class channelSelector = (Class)messageQueueAttr.getFirst((Object)"selector");
            if (!registry.containsBeanDefinition(messageSenderEndpointBeanName)) {
                this.registerMessageQueueSenderEndpointBeanDefinition(registry, messageSenderEndpointBeanName, channelName, messageFormat, channelSelector);
            } else {
                throw new BeanCreationException(messageSenderEndpointBeanName, String.format("MessageQueueReceiverEndpoint %s is already registered.", messageSenderEndpointBeanName));
            }
        }
    }

    private void registerMessageQueueSenderEndpointBeanDefinition(BeanDefinitionRegistry registry, String beanName, String channelName, MessageFormat messageFormat, Class<? extends Selector> channelSelector) {
        registry.registerBeanDefinition(beanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(DelegateMessageSenderEndpoint.class).addConstructorArgValue((Object)channelName).addConstructorArgValue(channelSelector).addConstructorArgValue((Object)messageFormat).setDependencyCheck(3).getBeanDefinition());
        LOG.info("Registered MessageQueueSenderEndpoint {} with for channelName {}, messageFormat {}", new Object[]{beanName, channelName, messageFormat});
    }
}

