/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint;

import de.otto.synapse.endpoint.InterceptorChain;
import de.otto.synapse.endpoint.MessageEndpoint;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.message.TextMessage;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractMessageEndpoint
implements MessageEndpoint {
    @Nonnull
    private final String channelName;
    @Nonnull
    private final MessageInterceptorRegistry interceptorRegistry;

    public AbstractMessageEndpoint(@Nonnull String channelName, @Nonnull MessageInterceptorRegistry interceptorRegistry) {
        this.channelName = Objects.requireNonNull(channelName, "ChannelName must not be null");
        this.interceptorRegistry = Objects.requireNonNull(interceptorRegistry);
    }

    @Override
    @Nonnull
    public final String getChannelName() {
        return this.channelName;
    }

    @Override
    @Nonnull
    public final InterceptorChain getInterceptorChain() {
        return this.interceptorRegistry.getInterceptorChain(this.channelName, this.getEndpointType());
    }

    @Override
    @Nullable
    public final TextMessage intercept(@Nonnull TextMessage message) {
        return this.getInterceptorChain().intercept(message);
    }
}

