/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.annotation;

import de.otto.synapse.annotation.AbstractAnnotationBasedBeanRegistrar;
import de.otto.synapse.annotation.EnableMessageLogReceiverEndpoint;
import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.endpoint.receiver.DelegateMessageLogReceiverEndpoint;
import de.otto.synapse.endpoint.receiver.MessageLogConsumerContainer;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.annotation.AnnotationAttributes;

public class MessageLogReceiverEndpointBeanRegistrar
extends AbstractAnnotationBasedBeanRegistrar {
    private static final Logger LOG = LoggerFactory.getLogger(MessageLogReceiverEndpointBeanRegistrar.class);

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableMessageLogReceiverEndpoint.class;
    }

    @Override
    protected void registerBeanDefinitions(String channelName, String beanName, AnnotationAttributes annotationAttributes, BeanDefinitionRegistry registry) {
        String processorBeanName = beanName + "Processor";
        if (registry.containsBeanDefinition(beanName)) {
            throw new BeanCreationException(beanName, String.format("MessageLogReceiverEndpoint %s is already registered.", beanName));
        }
        this.registerMessageLogReceiverEndpointBeanDefinition(registry, beanName, channelName);
        if (registry.containsBeanDefinition(processorBeanName)) {
            throw new BeanCreationException(beanName, String.format("MessageLogReceiverEndpointProcessor %s is already registered.", processorBeanName));
        }
        this.registerMessageLogReceiverEndpointProcessorBeanDefinition(registry, processorBeanName, beanName, channelName);
    }

    private void registerMessageLogReceiverEndpointBeanDefinition(BeanDefinitionRegistry registry, String beanName, String channelName) {
        registry.registerBeanDefinition(beanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(DelegateMessageLogReceiverEndpoint.class).addConstructorArgValue((Object)channelName).setDependencyCheck(3).getBeanDefinition());
        LOG.info("Registered MessageLogReceiverEndpoint {} with for channelName {}", (Object)beanName, (Object)channelName);
    }

    private void registerMessageLogReceiverEndpointProcessorBeanDefinition(BeanDefinitionRegistry registry, String beanName, String messageLogBeanName, String channelName) {
        registry.registerBeanDefinition(beanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(MessageLogConsumerContainer.class).addConstructorArgValue((Object)messageLogBeanName).addConstructorArgValue((Object)ChannelPosition.fromHorizon()).setDependencyCheck(3).getBeanDefinition());
        LOG.info("Registered MessageLogReceiverEndpointProcessor {} with for channelName {}", (Object)beanName, (Object)channelName);
    }
}

