/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.subscription.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import de.otto.synapse.subscription.events.SubscriptionCreated;
import de.otto.synapse.subscription.events.SubscriptionEvent;
import java.util.Set;

public class SubscriptionUpdated
extends SubscriptionEvent {
    private final Set<String> subscribedEntities;
    private final Set<String> unsubscribedEntities;

    public SubscriptionUpdated(@JsonProperty(value="id") String id, @JsonProperty(value="subscribedEntities") Set<String> subscribedEntities, @JsonProperty(value="unsubscribedEntities") Set<String> unsubscribedEntities) {
        super(id, SubscriptionEvent.Type.UPDATED);
        this.subscribedEntities = subscribedEntities;
        this.unsubscribedEntities = unsubscribedEntities;
    }

    @Override
    public SubscriptionCreated asSubscriptionCreated() {
        throw new ClassCastException("not a SubscriptionCreated event");
    }

    @Override
    public SubscriptionUpdated asSubscriptionUpdated() {
        return this;
    }

    public Set<String> getSubscribedEntities() {
        return this.subscribedEntities != null ? this.subscribedEntities : ImmutableSet.of();
    }

    public Set<String> getUnsubscribedEntities() {
        return this.unsubscribedEntities != null ? this.unsubscribedEntities : ImmutableSet.of();
    }

    @Override
    public String toString() {
        return "SubscriptionUpdated{subscribedEntities=" + this.subscribedEntities + ", unsubscribedEntities=" + this.unsubscribedEntities + '}';
    }
}

