/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore;

import com.google.common.collect.ImmutableSet;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.messagestore.ChannelPositions;
import de.otto.synapse.messagestore.Index;
import de.otto.synapse.messagestore.MessageStore;
import de.otto.synapse.messagestore.MessageStoreEntry;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class OnHeapCompactingMessageStore
implements MessageStore {
    private final long maxCapacity;
    private final boolean removeNullPayloadMessages;
    private final ChannelPositions channelPositions = new ChannelPositions();
    private final ConcurrentMap<Long, MessageStoreEntry> entries;
    private final ConcurrentMap<String, Long> internalKeyToIndexMapping = new ConcurrentHashMap<String, Long>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final AtomicLong nextKey = new AtomicLong();

    public OnHeapCompactingMessageStore(boolean removeNullPayloadMessages) {
        this(removeNullPayloadMessages, Long.MAX_VALUE);
    }

    public OnHeapCompactingMessageStore(boolean removeNullPayloadMessages, long maxCapacity) {
        this.removeNullPayloadMessages = removeNullPayloadMessages;
        this.maxCapacity = maxCapacity;
        this.entries = new ConcurrentLinkedHashMap.Builder().initialCapacity(1000).maximumWeightedCapacity(maxCapacity).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(MessageStoreEntry entry) {
        this.lock.writeLock().lock();
        try {
            String internalKey = entry.getChannelName() + ":" + entry.getTextMessage().getKey().compactionKey();
            long index = this.nextKey.getAndIncrement();
            if (entry.getTextMessage().getPayload() == null && this.removeNullPayloadMessages) {
                Long previousIndex = (Long)this.internalKeyToIndexMapping.get(internalKey);
                if (previousIndex != null) {
                    this.entries.remove(previousIndex);
                }
                this.internalKeyToIndexMapping.remove(internalKey);
            } else {
                Long previousIndex = (Long)this.internalKeyToIndexMapping.get(internalKey);
                if (previousIndex != null) {
                    this.entries.put(previousIndex, entry);
                } else {
                    this.entries.put(index, entry);
                    this.internalKeyToIndexMapping.put(internalKey, index);
                }
            }
            this.channelPositions.updateFrom(entry);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Set<String> getChannelNames() {
        this.lock.readLock().lock();
        try {
            ImmutableSet<String> immutableSet = this.channelPositions.getChannelNames();
            return immutableSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ImmutableSet<Index> getIndexes() {
        return ImmutableSet.of();
    }

    @Override
    public ChannelPosition getLatestChannelPosition(String channelName) {
        this.lock.readLock().lock();
        try {
            ChannelPosition channelPosition = this.channelPositions.getLatestChannelPosition(channelName);
            return channelPosition;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Stream<MessageStoreEntry> stream() {
        this.lock.readLock().lock();
        try {
            Stream<MessageStoreEntry> stream = this.entries.values().stream();
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Stream<MessageStoreEntry> stream(Index index, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long size() {
        return this.entries.size();
    }
}

