/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.translator;

import java.util.regex.Pattern;

public enum MessageFormat {
    V1,
    V2;

    public static final String SYNAPSE_MSG_FORMAT = "_synapse_msg_format";
    public static final String SYNAPSE_MSG_KEY = "_synapse_msg_key";
    public static final String SYNAPSE_MSG_COMPACTIONKEY = "compactionKey";
    public static final String SYNAPSE_MSG_PARTITIONKEY = "partitionKey";
    public static final String SYNAPSE_MSG_HEADERS = "_synapse_msg_headers";
    public static final String SYNAPSE_MSG_PAYLOAD = "_synapse_msg_payload";
    private static final Pattern V2_PATTERN;

    public static MessageFormat defaultMessageFormat() {
        return V1;
    }

    public static MessageFormat versionOf(String message) {
        if (message != null) {
            return V2_PATTERN.matcher(message).matches() ? V2 : V1;
        }
        return V1;
    }

    static {
        V2_PATTERN = Pattern.compile("\\{\\s*\"_synapse_msg_format\"\\s*:\\s*\"v2\".+");
    }
}

