/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.annotation;

import com.google.common.base.Strings;
import de.otto.synapse.annotation.AbstractAnnotationBasedBeanRegistrar;
import de.otto.synapse.annotation.BeanNameHelper;
import de.otto.synapse.annotation.EnableEventSource;
import de.otto.synapse.channel.selector.MessageLog;
import de.otto.synapse.endpoint.receiver.DelegateMessageLogReceiverEndpoint;
import de.otto.synapse.eventsource.DelegateEventSource;
import java.lang.annotation.Annotation;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.annotation.AnnotationAttributes;

public class EventSourceBeanRegistrar
extends AbstractAnnotationBasedBeanRegistrar {
    private static final Logger LOG = LoggerFactory.getLogger(EventSourceBeanRegistrar.class);

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableEventSource.class;
    }

    @Override
    protected void registerBeanDefinitions(String channelName, String beanName, AnnotationAttributes annotationAttributes, BeanDefinitionRegistry registry) {
        Class channelSelector = annotationAttributes.getClass("selector");
        String messageLogBeanName = Objects.toString(Strings.emptyToNull((String)annotationAttributes.getString("messageLogReceiverEndpoint")), BeanNameHelper.beanNameForMessageLogReceiverEndpoint(channelName));
        if (registry.containsBeanDefinition(messageLogBeanName)) {
            throw new BeanCreationException(messageLogBeanName, String.format("MessageLogReceiverEndpoint %s is already registered.", messageLogBeanName));
        }
        this.registerMessageLogBeanDefinition(registry, messageLogBeanName, channelName, channelSelector);
        if (registry.containsBeanDefinition(beanName)) {
            throw new BeanCreationException(beanName, String.format("EventSource %s is already registered.", beanName));
        }
        this.registerEventSourceBeanDefinition(registry, beanName, messageLogBeanName, channelName, channelSelector);
    }

    private void registerMessageLogBeanDefinition(BeanDefinitionRegistry registry, String beanName, String channelName, Class<? extends MessageLog> channelSelector) {
        registry.registerBeanDefinition(beanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(DelegateMessageLogReceiverEndpoint.class).addConstructorArgValue((Object)channelName).addConstructorArgValue(channelSelector).setDependencyCheck(3).getBeanDefinition());
        LOG.info("Registered MessageLogReceiverEndpoint {} with for channelName {}", (Object)beanName, (Object)channelName);
    }

    private void registerEventSourceBeanDefinition(BeanDefinitionRegistry registry, String beanName, String messageLogBeanName, String channelName, Class<? extends MessageLog> channelSelector) {
        registry.registerBeanDefinition(beanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(DelegateEventSource.class).addConstructorArgValue((Object)messageLogBeanName).addConstructorArgValue(channelSelector).setDependencyCheck(3).getBeanDefinition());
        LOG.info("Registered EventSource {} with for channelName {}", (Object)beanName, (Object)channelName);
    }
}

