/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.eventsource;

import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.channel.ShardResponse;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpoint;
import de.otto.synapse.eventsource.AbstractEventSource;
import de.otto.synapse.logging.LogHelper;
import de.otto.synapse.message.TextMessage;
import de.otto.synapse.messagestore.MessageStore;
import de.otto.synapse.messagestore.MessageStoreEntry;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class DefaultEventSource
extends AbstractEventSource {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEventSource.class);
    private static final int LOG_MESSAGE_COUNTER_EVERY_NTH_MESSAGE = 100000;
    private final MessageStore messageStore;
    private final Marker marker;

    public DefaultEventSource(@Nonnull MessageStore messageStore, @Nonnull MessageLogReceiverEndpoint messageLog) {
        super(messageLog);
        this.messageStore = messageStore;
        this.marker = null;
    }

    public DefaultEventSource(@Nonnull MessageStore messageStore, @Nonnull MessageLogReceiverEndpoint messageLog, @Nonnull Marker marker) {
        super(messageLog);
        this.messageStore = messageStore;
        this.marker = marker;
    }

    @Override
    @Nonnull
    public CompletableFuture<ChannelPosition> consumeUntil(@Nonnull Predicate<ShardResponse> stopCondition) {
        return ((CompletableFuture)this.consumeMessageStore().thenCompose(channelPosition -> this.getMessageLogReceiverEndpoint().consumeUntil((ChannelPosition)channelPosition, stopCondition))).handle((channelPosition, throwable) -> {
            if (throwable != null) {
                LOG.error(this.marker, "Failed to start consuming from EventSource {}: {}. Closing MessageStore.", new Object[]{this.getChannelName(), throwable.getMessage(), throwable});
            }
            try {
                this.messageStore.close();
            }
            catch (Exception e) {
                LOG.error(this.marker, "Unable to close() MessageStore: " + e.getMessage(), (Throwable)e);
            }
            return channelPosition;
        });
    }

    private CompletableFuture<ChannelPosition> consumeMessageStore() {
        int numberOfDispatcherThreads = 1;
        if (this.messageStore.isCompacting()) {
            numberOfDispatcherThreads = Runtime.getRuntime().availableProcessors();
        }
        ExecutorService executorService = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory("synapse-messagestore-dispatcher-"));
        Semaphore lock = new Semaphore(numberOfDispatcherThreads);
        String channelName = this.getChannelName();
        LOG.info(this.marker, "Starting to read message store for channel '{}'.", (Object)channelName);
        Instant startTime = Instant.now();
        AtomicLong messageCounter = new AtomicLong();
        long firstMessageLogTime = System.currentTimeMillis();
        AtomicLong previousMessageLogTime = new AtomicLong(System.currentTimeMillis());
        Map copyOfContextMap = MDC.getCopyOfContextMap();
        return CompletableFuture.supplyAsync(() -> {
            if (copyOfContextMap != null) {
                MDC.setContextMap((Map)copyOfContextMap);
            }
            this.messageStore.stream().filter(entry -> entry.getChannelName().equals(channelName)).map(MessageStoreEntry::getTextMessage).map(message -> this.getMessageLogReceiverEndpoint().intercept((TextMessage)message)).filter(Objects::nonNull).forEach(message -> {
                try {
                    lock.acquire();
                }
                catch (InterruptedException e) {
                    LOG.error(this.marker, e.getMessage(), (Throwable)e);
                }
                executorService.execute(() -> {
                    block4: {
                        long counter;
                        if (copyOfContextMap != null) {
                            MDC.setContextMap((Map)copyOfContextMap);
                        }
                        try {
                            this.getMessageLogReceiverEndpoint().getMessageDispatcher().accept((TextMessage)message);
                            counter = messageCounter.getAndIncrement();
                            if (counter <= 0L || counter % 100000L != 0L) break block4;
                        }
                        catch (Throwable throwable) {
                            long counter2 = messageCounter.getAndIncrement();
                            if (counter2 > 0L && counter2 % 100000L == 0L) {
                                double messagesPerSecond = LogHelper.calculateMessagesPerSecond(previousMessageLogTime.getAndSet(System.currentTimeMillis()), 100000L);
                                LOG.info(this.marker, "Consumed {} messages ({} per second) from message store for channel '{}'", new Object[]{counter2, String.format("%.2f", messagesPerSecond), channelName});
                            }
                            lock.release();
                            throw throwable;
                        }
                        double messagesPerSecond = LogHelper.calculateMessagesPerSecond(previousMessageLogTime.getAndSet(System.currentTimeMillis()), 100000L);
                        LOG.info(this.marker, "Consumed {} messages ({} per second) from message store for channel '{}'", new Object[]{counter, String.format("%.2f", messagesPerSecond), channelName});
                    }
                    lock.release();
                });
            });
            executorService.shutdown();
            try {
                executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
                LOG.info(this.marker, "Consumed a total of {} messages from message store for channel '{}', totalMessagesPerSecond={}", new Object[]{messageCounter.get(), channelName, String.format("%.2f", LogHelper.calculateMessagesPerSecond(firstMessageLogTime, messageCounter.get()))});
            }
            catch (InterruptedException e) {
                LOG.error(this.marker, e.getMessage(), (Throwable)e);
            }
            LOG.info(this.marker, "Finished reading message store for channel '{}'. Duration was {}.", (Object)channelName, (Object)Duration.between(startTime, Instant.now()));
            return this.messageStore.getLatestChannelPosition(channelName);
        }, Executors.newSingleThreadExecutor((ThreadFactory)new CustomizableThreadFactory("synapse-eventsource-")));
    }
}

