/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.receiver;

import de.otto.synapse.consumer.MessageConsumer;
import de.otto.synapse.consumer.MessageDispatcher;
import de.otto.synapse.endpoint.EndpointType;
import de.otto.synapse.endpoint.InterceptorChain;
import de.otto.synapse.endpoint.receiver.MessageQueueReceiverEndpoint;
import de.otto.synapse.endpoint.receiver.MessageQueueReceiverEndpointFactory;
import de.otto.synapse.message.TextMessage;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegateMessageQueueReceiverEndpoint
implements MessageQueueReceiverEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(DelegateMessageQueueReceiverEndpoint.class);
    private final MessageQueueReceiverEndpoint delegate;

    public DelegateMessageQueueReceiverEndpoint(@Nonnull String channelName, @Nonnull MessageQueueReceiverEndpointFactory messageQueueReceiverEndpointFactory) {
        this.delegate = messageQueueReceiverEndpointFactory.create(channelName);
        LOG.info("Created MessageQueueReceiverEndpoint for channelName={}", (Object)channelName);
    }

    @Override
    public CompletableFuture<Void> consume() {
        return this.delegate.consume();
    }

    @Override
    public void stop() {
        this.delegate.stop();
    }

    @Override
    public void register(MessageConsumer<?> messageConsumer) {
        this.delegate.register(messageConsumer);
    }

    @Override
    @Nonnull
    public MessageDispatcher getMessageDispatcher() {
        return this.delegate.getMessageDispatcher();
    }

    @Override
    @Nonnull
    public String getChannelName() {
        return this.delegate.getChannelName();
    }

    @Override
    @Nonnull
    public InterceptorChain getInterceptorChain() {
        return this.delegate.getInterceptorChain();
    }

    @Override
    @Nonnull
    public EndpointType getEndpointType() {
        return this.delegate.getEndpointType();
    }

    @Override
    @Nullable
    public TextMessage intercept(@Nonnull TextMessage message) {
        return this.delegate.intercept(message);
    }
}

