/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.logging;

import org.slf4j.Logger;
import org.slf4j.Marker;

public class ProgressLogger {
    private long percentageCount = 0L;
    private long currentCount = 0L;
    private final Logger logger;
    private final long expectedCount;
    private final Marker marker;

    public ProgressLogger(Logger logger, long expectedCount, Marker marker) {
        this.logger = logger;
        this.expectedCount = expectedCount;
        this.marker = marker;
    }

    public void incrementAndLog() {
        this.incrementAndLog(1);
    }

    public void incrementAndLog(int logStepSize) {
        ++this.currentCount;
        long percentage = this.currentCount * 100L / this.expectedCount;
        if (percentage > this.percentageCount) {
            ++this.percentageCount;
            if (this.percentageCount % (long)logStepSize == 0L) {
                this.logger.info(this.marker, "processed {}% of entries", (Object)percentage);
            }
        }
    }
}

