/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.state;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Sets;
import de.otto.synapse.state.StateRepository;
import de.otto.synapse.translator.ObjectMappers;
import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.dizitart.no2.Cursor;
import org.dizitart.no2.Document;
import org.dizitart.no2.Filter;
import org.dizitart.no2.FindOptions;
import org.dizitart.no2.IndexOptions;
import org.dizitart.no2.IndexType;
import org.dizitart.no2.Nitrite;
import org.dizitart.no2.NitriteBuilder;
import org.dizitart.no2.NitriteCollection;
import org.dizitart.no2.filters.Filters;

public class NitriteStateRepository<V>
implements StateRepository<V>,
Closeable {
    private static final String IDX_ID = "_idx_id";
    private static final TypeReference<Map<String, Object>> JSON_MAP = new TypeReference<Map<String, Object>>(){};
    private static final Document ID_PROJECTION = Document.createDocument((String)"_idx_id", null);
    private final String name;
    private final Class<V> valueType;
    private final Nitrite nitrite;
    private final NitriteCollection collection;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public NitriteStateRepository(String name, Class<V> valueType, Set<String> indexedFields, NitriteBuilder builder) {
        this.name = name;
        this.valueType = valueType;
        this.nitrite = builder.openOrCreate();
        this.collection = this.nitrite.getCollection(name);
        this.collection.createIndex(IDX_ID, IndexOptions.indexOptions((IndexType)IndexType.Unique));
        indexedFields.forEach(field -> this.collection.createIndex(field, IndexOptions.indexOptions((IndexType)IndexType.NonUnique)));
    }

    public NitriteStateRepository(String name, Class<V> valueType, Set<String> indexedFields) {
        this(name, valueType, indexedFields, Nitrite.builder().compressed());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> keySet() {
        try {
            this.lock.readLock().lock();
            Set<String> set = StreamSupport.stream(this.collection.find().project(ID_PROJECTION).spliterator(), false).map(d -> d.getOrDefault((Object)IDX_ID, (Object)"").toString()).collect(Collectors.toSet());
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<V> findBy(Filter filter) {
        return this.findInternal(() -> this.collection.find(filter));
    }

    public Collection<V> findBy(FindOptions findOptions) {
        return this.findInternal(() -> this.collection.find(findOptions));
    }

    public Collection<V> findBy(Filter filter, FindOptions findOptions) {
        return this.findInternal(() -> this.collection.find(filter, findOptions));
    }

    public Collection<V> findBy(String key, Object value) {
        return this.findInternal(() -> this.collection.find(Filters.eq((String)key, (Object)value)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<V> findInternal(Supplier<Cursor> findFunc) {
        try {
            this.lock.readLock().lock();
            Cursor documents = findFunc.get();
            Collection collection = StreamSupport.stream(documents.spliterator(), false).map(document -> ObjectMappers.currentObjectMapper().convertValue(document, this.valueType)).collect(Collectors.toList());
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<V> get(String key) {
        try {
            this.lock.readLock().lock();
            Document document = (Document)this.collection.find(Filters.eq((String)IDX_ID, (Object)key)).firstOrDefault();
            Optional optional = document != null ? Optional.of(ObjectMappers.currentObjectMapper().convertValue((Object)document, this.valueType)) : Optional.empty();
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void consumeAll(BiConsumer<? super String, ? super V> consumer) {
        try {
            this.lock.readLock().lock();
            this.collection.find().forEach(document -> {
                String key = document.get(IDX_ID).toString();
                Object value = ObjectMappers.currentObjectMapper().convertValue(document, this.valueType);
                if (key == null) {
                    throw new IllegalStateException("Unexpected null value found for required field '_idx_id'");
                }
                consumer.accept(key, (V)value);
            });
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<V> put(String key, V value) {
        try {
            this.lock.writeLock().lock();
            Map mapValue = (Map)ObjectMappers.currentObjectMapper().convertValue(value, JSON_MAP);
            Document document = new Document(mapValue);
            document.put(IDX_ID, (Object)key);
            Optional<V> previous = this.get(key);
            this.collection.insert(document, new Document[0]);
            Optional<V> optional = previous;
            return optional;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<V> compute(String key, BiFunction<? super String, ? super Optional<V>, ? extends V> remappingFunction) {
        try {
            Map mapValue;
            this.lock.writeLock().lock();
            Optional<V> previous = this.get(key);
            V computed = remappingFunction.apply(key, previous);
            if (previous.isPresent()) {
                if (computed != null) {
                    mapValue = (Map)ObjectMappers.currentObjectMapper().convertValue(computed, JSON_MAP);
                    Document document = new Document(mapValue);
                    document.put(IDX_ID, (Object)key);
                    this.collection.update(Filters.eq((String)IDX_ID, (Object)key), document);
                } else {
                    this.collection.remove(Filters.eq((String)IDX_ID, (Object)key));
                }
            } else if (computed != null) {
                mapValue = (Map)ObjectMappers.currentObjectMapper().convertValue(computed, JSON_MAP);
                Document document = new Document(mapValue);
                document.put(IDX_ID, (Object)key);
                this.collection.insert(document, new Document[0]);
            }
            Optional<V> optional = Optional.ofNullable(computed);
            return optional;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<V> remove(String key) {
        try {
            this.lock.writeLock().lock();
            Optional<V> previous = this.get(key);
            this.collection.remove(Filters.eq((String)IDX_ID, (Object)key));
            Optional<V> optional = previous;
            return optional;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        try {
            this.lock.writeLock().lock();
            this.collection.remove(Filters.ALL);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public long size() {
        try {
            this.lock.readLock().lock();
            long l = this.collection.size();
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void close() {
        try {
            this.lock.writeLock().lock();
            this.nitrite.close();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public static <V> Builder<V> builder(Class<V> clazz) {
        return new Builder(clazz);
    }

    public static final class Builder<V> {
        private final Class<V> clazz;
        private String name;
        private Set<String> indexedFields = Sets.newHashSet();
        private NitriteBuilder nitriteBuilder = Nitrite.builder();

        private Builder(Class<V> clazz) {
            this.clazz = clazz;
            this.name = clazz.getSimpleName();
        }

        public Builder<V> with(Function<NitriteBuilder, NitriteBuilder> func) {
            func.apply(this.nitriteBuilder);
            return this;
        }

        public Builder<V> withName(String val) {
            this.name = val;
            return this;
        }

        public Builder<V> withIndexed(String ... fields) {
            return this.withIndexed(Sets.newHashSet((Object[])fields));
        }

        public Builder<V> withIndexed(Set<String> fields) {
            this.indexedFields.addAll(fields);
            return this;
        }

        public NitriteStateRepository<V> build() {
            return new NitriteStateRepository<V>(this.name, this.clazz, this.indexedFields, this.nitriteBuilder);
        }
    }
}

