/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.subscription;

import de.otto.synapse.message.Message;
import de.otto.synapse.state.StateRepository;
import de.otto.synapse.subscription.EntityToMessageListTransformer;
import de.otto.synapse.subscription.SnapshotProvider;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class StateRepositorySnapshotProvider<E>
implements SnapshotProvider {
    private final String channelName;
    private final StateRepository<E> stateRepository;
    private final EntityToMessageListTransformer<E> entityToMessagesTransformer;

    public StateRepositorySnapshotProvider(String channelName, StateRepository<E> stateRepository) {
        this(channelName, stateRepository, (key, payload) -> Collections.singletonList(Message.message(key, payload)));
    }

    public StateRepositorySnapshotProvider(String channelName, StateRepository<E> stateRepository, EntityToMessageListTransformer<E> entityToMessagesTransformer) {
        this.channelName = channelName;
        this.stateRepository = stateRepository;
        this.entityToMessagesTransformer = entityToMessagesTransformer;
    }

    @Override
    public String channelName() {
        return this.channelName;
    }

    @Override
    public Stream<? extends Message<?>> snapshot(String entityId) {
        return this.stateRepository.get(entityId).map(t -> ((List)this.entityToMessagesTransformer.apply(entityId, t)).stream()).orElse(Stream.empty());
    }
}

