/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.sender;

import com.google.common.collect.ImmutableList;
import de.otto.synapse.endpoint.sender.MessageSender;
import de.otto.synapse.message.Message;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class TeeMessageSender
implements MessageSender {
    @Nonnull
    private final ImmutableList<? extends MessageSender> endpoints;

    public TeeMessageSender(@Nonnull ImmutableList<? extends MessageSender> endpoints) {
        this.endpoints = endpoints;
    }

    public TeeMessageSender(@Nonnull List<? extends MessageSender> endpoints) {
        this.endpoints = ImmutableList.copyOf(endpoints);
    }

    public TeeMessageSender(MessageSender ... endpoints) {
        this.endpoints = ImmutableList.copyOf((Object[])endpoints);
    }

    @Override
    public CompletableFuture<Void> send(@Nonnull Message<?> message) {
        return CompletableFuture.allOf((CompletableFuture[])this.endpoints.stream().map(sender -> sender.send(message)).toArray(CompletableFuture[]::new));
    }

    @Override
    public CompletableFuture<Void> sendBatch(@Nonnull Stream<? extends Message<?>> batch) {
        return CompletableFuture.allOf((CompletableFuture[])this.endpoints.stream().map(sender -> sender.sendBatch(batch)).toArray(CompletableFuture[]::new));
    }
}

