/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.translator;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import de.otto.synapse.message.Header;
import de.otto.synapse.message.Key;
import de.otto.synapse.message.TextMessage;
import de.otto.synapse.translator.Decoder;
import de.otto.synapse.translator.MessageFormat;
import de.otto.synapse.translator.ObjectMappers;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTextDecoder<T>
implements Decoder<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTextDecoder.class);
    private static final TypeReference<Map<String, String>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, String>>(){};

    protected TextMessage decode(Key prototypeKey, Header prototypeHeader, String body) {
        switch (MessageFormat.versionOf(body)) {
            case V1: {
                return TextMessage.of(prototypeKey, prototypeHeader, body);
            }
            case V2: {
                try {
                    JsonNode json = AbstractTextDecoder.parseRecordBody(body);
                    return TextMessage.of(AbstractTextDecoder.keyFrom(json).orElse(prototypeKey), Header.copyOf(prototypeHeader).withAttributes(AbstractTextDecoder.attributesFrom(json)).build(), AbstractTextDecoder.payloadFrom(json));
                }
                catch (RuntimeException e) {
                    LOG.error("Exception caught while parsing record {}: {}", (Object)body, (Object)e.getMessage());
                    return TextMessage.of(prototypeKey, prototypeHeader, body);
                }
            }
        }
        throw new IllegalStateException("Unsupported message format: " + body);
    }

    private static Map<String, String> attributesFrom(JsonNode json) {
        JsonNode headersJson = json.get("_synapse_msg_headers");
        if (headersJson != null) {
            return (Map)ObjectMappers.currentObjectMapper().convertValue((Object)headersJson, MAP_TYPE_REFERENCE);
        }
        return Collections.emptyMap();
    }

    private static Optional<Key> keyFrom(JsonNode json) {
        JsonNode keyNode = json.get("_synapse_msg_key");
        if (keyNode == null || keyNode.isNull()) {
            return Optional.empty();
        }
        if (keyNode.isObject()) {
            String partitionKey = keyNode.get("partitionKey").textValue();
            String compactionKey = keyNode.get("compactionKey").textValue();
            return Optional.of(Key.of(partitionKey, compactionKey));
        }
        String msg = "Unexpected json node containing " + json + ": ";
        LOG.error(msg);
        throw new IllegalStateException(msg);
    }

    private static String payloadFrom(JsonNode json) {
        JsonNode payloadJson = json.get("_synapse_msg_payload");
        if (payloadJson == null || payloadJson.isNull()) {
            return null;
        }
        if (payloadJson.isObject()) {
            return payloadJson.toString();
        }
        return payloadJson.asText();
    }

    private static JsonNode parseRecordBody(String body) {
        try {
            return ObjectMappers.currentObjectMapper().readTree(body);
        }
        catch (IOException e) {
            LOG.error("Error parsing body={} from Kinesis record: {}", (Object)body, (Object)e.getMessage());
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

