/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.otto.synapse.messagestore.CalculatedValueIndexer;
import de.otto.synapse.messagestore.CompositeIndexer;
import de.otto.synapse.messagestore.Index;
import de.otto.synapse.messagestore.Indexer;
import de.otto.synapse.messagestore.MessageStoreEntry;
import de.otto.synapse.messagestore.StaticValueIndexer;
import java.util.Objects;
import javax.annotation.Nonnull;

@Beta
public class Indexers {
    private Indexers() {
    }

    public static Indexer noOpIndexer() {
        return new Indexer(){

            @Override
            @Nonnull
            public ImmutableSet<Index> getIndexes() {
                return ImmutableSet.of();
            }

            @Override
            public boolean supports(@Nonnull Index index) {
                return false;
            }

            @Override
            @Nonnull
            public String calc(@Nonnull Index index, @Nonnull MessageStoreEntry entry) {
                return "";
            }

            @Override
            @Nonnull
            public MessageStoreEntry index(@Nonnull MessageStoreEntry entry) {
                return entry;
            }
        };
    }

    public static Indexer composite(ImmutableList<Indexer> indexers) {
        return new CompositeIndexer(indexers);
    }

    public static Indexer composite(Indexer ... indexers) {
        Objects.requireNonNull(indexers, "Parameter must not be null");
        return new CompositeIndexer((ImmutableList<Indexer>)ImmutableList.copyOf((Object[])indexers));
    }

    public static Indexer originIndexer(@Nonnull String origin) {
        return new StaticValueIndexer(Index.ORIGIN, origin);
    }

    public static Indexer serviceInstanceIndexer(@Nonnull String serviceInstance) {
        return new StaticValueIndexer(Index.SERVICE_INSTANCE, serviceInstance);
    }

    public static Indexer partitionKeyIndexer() {
        return new CalculatedValueIndexer(Index.PARTITION_KEY, entry -> entry.getTextMessage().getKey().partitionKey());
    }

    public static Indexer journalKeyIndexer() {
        return new CalculatedValueIndexer(Index.JOURNAL_KEY, entry -> entry.getTextMessage().getKey().partitionKey());
    }

    public static Indexer channelNameIndexer() {
        return new CalculatedValueIndexer(Index.CHANNEL_NAME, entry -> entry.getChannelName());
    }
}

