/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.journal;

import de.otto.synapse.endpoint.MessageInterceptorRegistration;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.journal.Journal;
import de.otto.synapse.journal.JournalingInterceptor;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(JournalRegistry.class);
    private final ConcurrentMap<String, Journal> journals;
    private final Set<String> registeredInterceptors = Collections.newSetFromMap(new ConcurrentHashMap());
    private final MessageInterceptorRegistry registry;

    public JournalRegistry(List<Journal> journals, MessageInterceptorRegistry registry) {
        this.registry = registry;
        this.journals = new ConcurrentHashMap<String, Journal>();
        journals.forEach(this::add);
    }

    public Optional<Journal> getJournal(String name) {
        return Optional.ofNullable((Journal)this.journals.get(name));
    }

    private void add(Journal journal) {
        Journal existing = this.journals.putIfAbsent(journal.getName(), journal);
        if (existing != null) {
            throw new IllegalStateException("Unable to register Journal " + journal.getName() + " as there is already a different journal registered for this name");
        }
        journal.getJournaledChannels().forEach(channelName -> {
            if (!this.registeredInterceptors.contains(channelName + journal.getName())) {
                JournalingInterceptor journalingInterceptor = new JournalingInterceptor((String)channelName, journal);
                this.registry.register(MessageInterceptorRegistration.matchingReceiverChannelsWith(channelName, journalingInterceptor, Integer.MAX_VALUE));
                this.registeredInterceptors.add(channelName + journal.getName());
            }
        });
    }

    public boolean hasJournal(String journalName) {
        return this.journals.containsKey(journalName);
    }
}

