/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.channel;

import com.google.common.base.Predicates;
import de.otto.synapse.channel.ShardResponse;
import de.otto.synapse.message.DefaultHeaderAttr;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Predicate;

public final class StopCondition {
    public static Predicate<ShardResponse> shutdown() {
        return Predicates.alwaysFalse();
    }

    public static Predicate<ShardResponse> timestamp(Instant timestamp) {
        return StopCondition.timestamp(timestamp, Clock.systemDefaultZone());
    }

    public static Predicate<ShardResponse> timestamp(Instant timestamp, Clock clock) {
        return _x -> clock.instant().isAfter(timestamp);
    }

    public static Predicate<ShardResponse> arrivalTimestampAfterNow() {
        return StopCondition.arrivalTimestampAfterNow(Clock.systemDefaultZone());
    }

    public static Predicate<ShardResponse> arrivalTimestampAfterNow(Clock clock) {
        Instant now = clock.instant();
        return response -> response.getMessages().stream().anyMatch(m -> m.getHeader().getAsInstant(DefaultHeaderAttr.MSG_ARRIVAL_TS, Instant.MIN).isAfter(now));
    }

    public static Predicate<ShardResponse> endOfChannel() {
        return response -> response.getDurationBehind().equals(Duration.ZERO);
    }

    public static Predicate<ShardResponse> emptyResponse() {
        return response -> response.getMessages().isEmpty();
    }

    private StopCondition() {
    }
}

