/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.subscription;

import de.otto.synapse.endpoint.MessageInterceptor;
import de.otto.synapse.endpoint.sender.MessageSenderEndpoint;
import de.otto.synapse.message.TextMessage;
import de.otto.synapse.subscription.Subscription;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SubscriptionInterceptor
implements MessageInterceptor {
    private final Subscription subscription;
    private final MessageSenderEndpoint targetSenderEndpoint;

    public SubscriptionInterceptor(Subscription subscription, MessageSenderEndpoint targetSenderEndpoint) {
        this.subscription = subscription;
        this.targetSenderEndpoint = targetSenderEndpoint;
    }

    Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    @Nullable
    public TextMessage intercept(@Nonnull TextMessage message) {
        if (this.subscription.getSubscribedEntities().contains(message.getKey().partitionKey())) {
            this.targetSenderEndpoint.send(message);
        }
        return message;
    }
}

