/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.subscription;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.otto.synapse.subscription.Subscription;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class Subscriptions {
    private static final Logger LOG = LoggerFactory.getLogger(Subscriptions.class);
    final ConcurrentMap<String, Map<String, Subscription>> subscriptions = Maps.newConcurrentMap();

    public void addIfMissing(Subscription subscription) {
        String channelName = subscription.getChannelName();
        LOG.info("Received subscription for channel " + channelName);
        this.subscriptions.putIfAbsent(channelName, Maps.newConcurrentMap());
        ((Map)this.subscriptions.get(channelName)).putIfAbsent(subscription.getId(), subscription);
    }

    public void subscribe(String subscriptionId, Set<String> subscribedEntities) {
        this.get(subscriptionId).orElseThrow(() -> new IllegalArgumentException("Subscription does not exist")).subscribe(subscribedEntities);
    }

    public void unsubscribe(String subscriptionId, Set<String> unsubscribedEntities) {
        this.get(subscriptionId).ifPresent(subscription -> subscription.unsubscribe(unsubscribedEntities));
    }

    public Collection<Subscription> subscriptionsFor(String channelName) {
        return this.subscriptions.getOrDefault(channelName, (Map<String, Subscription>)ImmutableMap.of()).values();
    }

    public Optional<Subscription> get(String subscriptionId) {
        for (Map s : this.subscriptions.values()) {
            Optional<Subscription> optionalSubscription = s.values().stream().filter(subscription -> subscription.getId().equals(subscriptionId)).findAny();
            if (!optionalSubscription.isPresent()) continue;
            return optionalSubscription;
        }
        return Optional.empty();
    }

    public void remove(String subscriptionId) {
        LOG.info("Removed subscription " + subscriptionId);
        this.subscriptions.values().forEach(map -> map.remove(subscriptionId));
    }
}

