/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.annotation;

import de.otto.synapse.annotation.AbstractAnnotationBasedBeanRegistrar;
import de.otto.synapse.annotation.EnableMessageSenderEndpoint;
import de.otto.synapse.endpoint.sender.DelegateMessageSenderEndpoint;
import de.otto.synapse.translator.MessageFormat;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.annotation.AnnotationAttributes;

public class MessageSenderEndpointBeanRegistrar
extends AbstractAnnotationBasedBeanRegistrar {
    private static final Logger LOG = LoggerFactory.getLogger(MessageSenderEndpointBeanRegistrar.class);

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableMessageSenderEndpoint.class;
    }

    @Override
    protected void registerBeanDefinitions(String channelName, String beanName, AnnotationAttributes annotationAttributes, BeanDefinitionRegistry registry) {
        Class channelSelector = annotationAttributes.getClass("selector");
        MessageFormat messageFormat = (MessageFormat)annotationAttributes.getEnum("messageFormat");
        if (registry.containsBeanDefinition(beanName)) {
            throw new BeanCreationException(beanName, String.format("MessageQueueReceiverEndpoint %s is already registered.", beanName));
        }
        registry.registerBeanDefinition(beanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(DelegateMessageSenderEndpoint.class).addConstructorArgValue((Object)channelName).addConstructorArgValue((Object)channelSelector).addConstructorArgValue((Object)messageFormat).setDependencyCheck(3).getBeanDefinition());
        LOG.info("Registered MessageQueueSenderEndpoint {} with for channelName {}, messageFormat {}", new Object[]{beanName, channelName, messageFormat});
    }
}

