/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.journal;

import com.google.common.base.Preconditions;
import de.otto.synapse.endpoint.MessageInterceptor;
import de.otto.synapse.journal.Journal;
import de.otto.synapse.message.TextMessage;
import de.otto.synapse.messagestore.Index;
import de.otto.synapse.messagestore.MessageStoreEntry;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalingInterceptor
implements MessageInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(JournalingInterceptor.class);
    private final String channelName;
    private final Journal journal;

    public JournalingInterceptor(@Nonnull String channelName, @Nonnull Journal journal) {
        Preconditions.checkState((boolean)journal.getMessageStore().getIndexes().contains((Object)Index.JOURNAL_KEY), (Object)"The provided MessageStore must be indexed for Index.JOURNAL_KEY.");
        this.channelName = channelName;
        this.journal = journal;
    }

    @Override
    @Nonnull
    public TextMessage intercept(@Nonnull TextMessage message) {
        LOG.debug("Added message {} to Journal using messageStore {}", (Object)message, (Object)this.journal.getName());
        this.journal.getMessageStore().add(MessageStoreEntry.of(this.channelName, message));
        return message;
    }

    public Journal getJournal() {
        return this.journal;
    }
}

