/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.otto.synapse.messagestore.Index;
import de.otto.synapse.messagestore.Indexer;
import de.otto.synapse.messagestore.MessageStoreEntry;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Function;

@Beta
public class CalculatedValueIndexer
implements Indexer {
    private final Index index;
    private final Function<MessageStoreEntry, String> calculator;

    public CalculatedValueIndexer(@Nonnull Index index, @Nonnull Function<MessageStoreEntry, String> calculator) {
        this.index = Objects.requireNonNull(index);
        this.calculator = calculator;
    }

    @Override
    @Nonnull
    public ImmutableSet<Index> getIndexes() {
        return ImmutableSet.of((Object)this.index);
    }

    @Override
    public boolean supports(@Nonnull Index index) {
        return this.index.equals(index);
    }

    @Override
    public String calc(@Nonnull Index index, @Nonnull MessageStoreEntry entry) {
        if (this.supports(index)) {
            return this.calculator.apply(entry);
        }
        throw new IllegalArgumentException("Unknown index " + index.getName());
    }

    @Override
    @Nonnull
    public MessageStoreEntry index(@Nonnull MessageStoreEntry entry) {
        return MessageStoreEntry.of(entry.getChannelName(), (ImmutableMap<Index, String>)ImmutableMap.of((Object)this.index, (Object)this.calc(this.index, entry)), entry.getTextMessage());
    }
}

