/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore;

import com.google.common.collect.ImmutableMap;
import de.otto.synapse.message.TextMessage;
import de.otto.synapse.messagestore.Index;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;

public final class MessageStoreEntry
implements Serializable {
    private static final long serialVersionUID = 8581441886626974935L;
    @Nonnull
    private final String channelName;
    @Nonnull
    private final ImmutableMap<Index, String> filterValues;
    @Nonnull
    private final TextMessage textMessage;

    private MessageStoreEntry(@Nonnull String channelName, @Nonnull ImmutableMap<Index, String> filterValues, @Nonnull TextMessage textMessage) {
        this.channelName = channelName;
        this.filterValues = filterValues;
        this.textMessage = textMessage;
    }

    public static MessageStoreEntry of(@Nonnull String channelName, @Nonnull TextMessage textMessage) {
        return new MessageStoreEntry(channelName, (ImmutableMap<Index, String>)ImmutableMap.of(), textMessage);
    }

    public static MessageStoreEntry of(@Nonnull String channelName, @Nonnull ImmutableMap<Index, String> filterValues, @Nonnull TextMessage textMessage) {
        return new MessageStoreEntry(channelName, filterValues, textMessage);
    }

    @Nonnull
    public String getChannelName() {
        return this.channelName;
    }

    @Nonnull
    public ImmutableMap<Index, String> getFilterValues() {
        return this.filterValues;
    }

    @Nonnull
    public TextMessage getTextMessage() {
        return this.textMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessageStoreEntry)) {
            return false;
        }
        MessageStoreEntry that = (MessageStoreEntry)o;
        return this.channelName.equals(that.channelName) && this.filterValues.equals(that.filterValues) && this.textMessage.equals(that.textMessage);
    }

    public int hashCode() {
        return Objects.hash(this.channelName, this.filterValues, this.textMessage);
    }

    public String toString() {
        return "MessageStoreEntry{channelName='" + this.channelName + "', filterValues=" + this.filterValues + ", textMessage=" + this.textMessage + "}";
    }
}

