/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.info;

import de.otto.synapse.channel.ChannelDurationBehind;
import de.otto.synapse.info.MessageReceiverStatus;
import java.util.Objects;
import java.util.Optional;

public class MessageReceiverNotification {
    private String channelName;
    private MessageReceiverStatus status;
    private ChannelDurationBehind channelDurationBehind;
    private String message;

    protected MessageReceiverNotification(Builder builder) {
        this.channelDurationBehind = builder.channelDurationBehind;
        this.channelName = Objects.requireNonNull(builder.channelName);
        this.status = Objects.requireNonNull(builder.status);
        this.message = Objects.requireNonNull(builder.message);
    }

    public Optional<ChannelDurationBehind> getChannelDurationBehind() {
        return Optional.ofNullable(this.channelDurationBehind);
    }

    public String getChannelName() {
        return this.channelName;
    }

    public MessageReceiverStatus getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageReceiverNotification that = (MessageReceiverNotification)o;
        return Objects.equals(this.channelName, that.channelName) && this.status == that.status && Objects.equals(this.channelDurationBehind, that.channelDurationBehind) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.channelName, this.status, this.channelDurationBehind, this.message});
    }

    public String toString() {
        return "MessageReceiverNotification{channelName='" + this.channelName + "', status=" + this.status + ", channelDurationBehind=" + this.channelDurationBehind + ", message='" + this.message + "'}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MessageReceiverNotification copy) {
        Builder builder = new Builder();
        builder.channelDurationBehind = copy.getChannelDurationBehind().orElse(null);
        builder.channelName = copy.getChannelName();
        builder.status = copy.getStatus();
        return builder;
    }

    public static class Builder {
        private ChannelDurationBehind channelDurationBehind = null;
        private String channelName = "";
        private MessageReceiverStatus status;
        private String message = "";

        protected Builder() {
        }

        public Builder withChannelDurationBehind(ChannelDurationBehind val) {
            this.channelDurationBehind = val;
            return this;
        }

        public Builder withChannelName(String val) {
            this.channelName = val;
            return this;
        }

        public Builder withStatus(MessageReceiverStatus val) {
            this.status = val;
            return this;
        }

        public Builder withMessage(String msg) {
            this.message = msg;
            return this;
        }

        public MessageReceiverNotification build() {
            return new MessageReceiverNotification(this);
        }
    }
}

