/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.translator;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.otto.synapse.message.Message;
import de.otto.synapse.message.TextMessage;
import de.otto.synapse.translator.MessageTranslator;
import de.otto.synapse.translator.ObjectMappers;
import jakarta.annotation.Nonnull;

public class TextMessageTranslator
implements MessageTranslator<TextMessage> {
    @Override
    @Nonnull
    public TextMessage apply(@Nonnull Message<?> message) {
        try {
            if (message.getPayload() instanceof String) {
                return TextMessage.of(message);
            }
            String payload = message.getPayload() != null ? ObjectMappers.currentObjectMapper().writeValueAsString((Object)message.getPayload()) : null;
            return TextMessage.of(message.getKey(), message.getHeader(), payload);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

