/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.consumer;

import de.otto.synapse.consumer.MessageConsumer;
import de.otto.synapse.message.Message;
import jakarta.annotation.Nonnull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.regex.Pattern;

public class MethodInvokingMessageConsumer<T>
implements MessageConsumer<T> {
    private final Pattern keyPattern;
    private final Class<T> payloadType;
    private final Object instance;
    private final Method method;

    public MethodInvokingMessageConsumer(String keyPattern, Class<T> payloadType, Object instance, Method method) {
        Objects.requireNonNull(keyPattern, "keyPattern must not be null");
        Objects.requireNonNull(payloadType, "payloadType must not be null");
        Objects.requireNonNull(instance, "Unable to build MethodInvokingMessageConsumer: instance parameter is null");
        Objects.requireNonNull(method, "Unable to build MethodInvokingNMessageConsumer: method parameter is null");
        if (method.getParameterCount() != 1) {
            throw new IllegalArgumentException("Unable to build MethodInvokingMessageConsumer: illegal number of arguments");
        }
        Class<?> paramType = method.getParameterTypes()[0];
        if (!paramType.equals(Message.class)) {
            throw new IllegalArgumentException("Unable to build MethodInvokingMessageConsumer: expected parameter type is Message, not " + paramType.getName());
        }
        this.keyPattern = Pattern.compile(keyPattern);
        this.payloadType = payloadType;
        this.method = method;
        this.instance = instance;
    }

    @Override
    @Nonnull
    public Class<T> payloadType() {
        return this.payloadType;
    }

    @Override
    @Nonnull
    public Pattern keyPattern() {
        return this.keyPattern;
    }

    @Override
    public void accept(Message<T> message) {
        try {
            this.method.invoke(this.instance, message);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }
}

