/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.sender;

import de.otto.synapse.channel.selector.Selector;
import de.otto.synapse.endpoint.BestMatchingSelectableComparator;
import de.otto.synapse.endpoint.EndpointType;
import de.otto.synapse.endpoint.InterceptorChain;
import de.otto.synapse.endpoint.sender.MessageSenderEndpoint;
import de.otto.synapse.endpoint.sender.MessageSenderEndpointFactory;
import de.otto.synapse.message.Message;
import de.otto.synapse.message.TextMessage;
import de.otto.synapse.translator.MessageFormat;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegateMessageSenderEndpoint
implements MessageSenderEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(DelegateMessageSenderEndpoint.class);
    private final MessageSenderEndpoint delegate;
    @Nonnull
    private final MessageFormat messageFormat;

    public DelegateMessageSenderEndpoint(@Nonnull String channelName, @Nonnull Class<? extends Selector> selector, @Nonnull MessageFormat messageFormat, List<MessageSenderEndpointFactory> factories) {
        this.messageFormat = messageFormat;
        MessageSenderEndpointFactory messageSenderEndpointFactory = factories.stream().filter(factory -> factory.matches(selector)).min(new BestMatchingSelectableComparator(selector)).orElseThrow(() -> new IllegalStateException(String.format("Unable to create MessageSenderEndpoint for channelName=%s: no matching MessageSenderEndpointFactory found in the ApplicationContext.", channelName)));
        this.delegate = messageSenderEndpointFactory.create(channelName, messageFormat);
        LOG.info("Created MessageSenderEndpoint for channelName={}", (Object)channelName);
    }

    @Override
    @Nonnull
    public String getChannelName() {
        return this.delegate.getChannelName();
    }

    @Nonnull
    public MessageFormat getMessageFormat() {
        return this.messageFormat;
    }

    @Override
    @Nonnull
    public InterceptorChain getInterceptorChain() {
        return this.delegate.getInterceptorChain();
    }

    @Override
    @Nonnull
    public EndpointType getEndpointType() {
        return this.delegate.getEndpointType();
    }

    @Override
    @Nullable
    public TextMessage intercept(@Nonnull TextMessage message) {
        return this.delegate.intercept(message);
    }

    @Override
    public CompletableFuture<Void> send(@Nonnull Message<?> message) {
        return this.delegate.send(message);
    }

    @Override
    public CompletableFuture<Void> sendBatch(@Nonnull Stream<? extends Message<?>> batch) {
        return this.delegate.sendBatch(batch);
    }
}

