/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.configuration;

import de.otto.synapse.annotation.MessageQueueConsumerBeanPostProcessor;
import de.otto.synapse.configuration.SynapseAutoConfiguration;
import de.otto.synapse.endpoint.receiver.MessageQueueConsumerProcess;
import de.otto.synapse.endpoint.receiver.MessageQueueReceiverEndpoint;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Role;

@Import(value={SynapseAutoConfiguration.class})
public class MessageQueueReceiverEndpointAutoConfiguration {
    @Autowired(required=false)
    private List<MessageQueueReceiverEndpoint> messageQueueReceiverEndpoints;

    @Bean
    @ConditionalOnProperty(prefix="synapse", name={"consumer-process.enabled"}, havingValue="true", matchIfMissing=true)
    public MessageQueueConsumerProcess messageQueueConsumerProcess() {
        return new MessageQueueConsumerProcess(this.messageQueueReceiverEndpoints);
    }

    @Bean
    @Role(value=2)
    public MessageQueueConsumerBeanPostProcessor messageQueueConsumerAnnotationBeanPostProcessor() {
        return new MessageQueueConsumerBeanPostProcessor();
    }
}

