/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableSet;
import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.messagestore.ChannelPositions;
import de.otto.synapse.messagestore.Index;
import de.otto.synapse.messagestore.MessageStore;
import de.otto.synapse.messagestore.MessageStoreEntry;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Stream;

public class OnHeapRingBufferMessageStore
implements MessageStore {
    private final Queue<MessageStoreEntry> entries;
    private final ChannelPositions channelPositions = new ChannelPositions();

    public OnHeapRingBufferMessageStore() {
        this.entries = EvictingQueue.create((int)100);
    }

    public OnHeapRingBufferMessageStore(int capacity) {
        this.entries = EvictingQueue.create((int)capacity);
    }

    @Override
    public synchronized void add(MessageStoreEntry entry) {
        this.entries.add(entry);
        this.channelPositions.updateFrom(entry);
    }

    @Override
    public synchronized Set<String> getChannelNames() {
        return this.channelPositions.getChannelNames();
    }

    @Override
    public ImmutableSet<Index> getIndexes() {
        return ImmutableSet.of();
    }

    @Override
    public synchronized ChannelPosition getLatestChannelPosition(String channelName) {
        return this.channelPositions.getLatestChannelPosition(channelName);
    }

    @Override
    public synchronized Stream<MessageStoreEntry> stream() {
        return this.entries.stream();
    }

    @Override
    public Stream<MessageStoreEntry> stream(Index index, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized long size() {
        return this.entries.size();
    }
}

