/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.subscription;

import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;

public class Subscription {
    private final String id;
    private final String channelName;
    private final String targetChannelName;
    private final Set<String> subscribedEntities;

    public Subscription(String id, String channelName, String targetChannelName) {
        this.id = id;
        this.channelName = channelName;
        this.targetChannelName = targetChannelName;
        this.subscribedEntities = Sets.newConcurrentHashSet();
    }

    public String getId() {
        return this.id;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getTargetChannelName() {
        return this.targetChannelName;
    }

    public Set<String> getSubscribedEntities() {
        return this.subscribedEntities;
    }

    public void subscribe(Set<String> subscribedEntities) {
        this.subscribedEntities.addAll(subscribedEntities);
    }

    public void unsubscribe(Set<String> unsubscribedEntities) {
        this.subscribedEntities.removeAll(unsubscribedEntities);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Subscription)) {
            return false;
        }
        Subscription that = (Subscription)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.channelName, that.channelName) && Objects.equals(this.targetChannelName, that.targetChannelName) && Objects.equals(this.subscribedEntities, that.subscribedEntities);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.channelName, this.targetChannelName, this.subscribedEntities);
    }

    public String toString() {
        return "Subscription{id='" + this.id + "', channelName='" + this.channelName + "', targetChannelName='" + this.targetChannelName + "', subscribedEntities=" + this.subscribedEntities + "}";
    }
}

