/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore;

import com.google.common.collect.ImmutableSet;
import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.messagestore.ChannelPositions;
import de.otto.synapse.messagestore.Index;
import de.otto.synapse.messagestore.Indexer;
import de.otto.synapse.messagestore.Indexers;
import de.otto.synapse.messagestore.MessageStore;
import de.otto.synapse.messagestore.MessageStoreEntry;
import java.util.Deque;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;

public class OnHeapIndexingMessageStore
implements MessageStore {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Deque<MessageStoreEntry> entries = new ConcurrentLinkedDeque<MessageStoreEntry>();
    private final ConcurrentMap<String, Deque<MessageStoreEntry>> indexes = new ConcurrentHashMap<String, Deque<MessageStoreEntry>>();
    private final ChannelPositions channelPositions = new ChannelPositions();
    private final Indexer indexer;

    public OnHeapIndexingMessageStore() {
        this.indexer = Indexers.noOpIndexer();
    }

    public OnHeapIndexingMessageStore(Indexer indexer) {
        this.indexer = indexer;
    }

    @Override
    public void add(MessageStoreEntry entry) {
        this.lock.writeLock().lock();
        try {
            MessageStoreEntry indexedEntry = this.indexer.index(entry);
            this.entries.add(indexedEntry);
            indexedEntry.getFilterValues().forEach((key, value) -> {
                String indexKey = this.indexKeyOf((Index)key, (String)value);
                if (!this.indexes.containsKey(indexKey)) {
                    this.indexes.put(indexKey, new ConcurrentLinkedDeque());
                }
                ((Deque)this.indexes.get(indexKey)).addLast(indexedEntry);
            });
            this.channelPositions.updateFrom(indexedEntry);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Set<String> getChannelNames() {
        this.lock.readLock().lock();
        try {
            ImmutableSet<String> immutableSet = this.channelPositions.getChannelNames();
            return immutableSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ImmutableSet<Index> getIndexes() {
        return this.indexer.getIndexes();
    }

    @Override
    public ChannelPosition getLatestChannelPosition(String channelName) {
        this.lock.readLock().lock();
        try {
            ChannelPosition channelPosition = this.channelPositions.getLatestChannelPosition(channelName);
            return channelPosition;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Stream<MessageStoreEntry> stream() {
        this.lock.readLock().lock();
        try {
            Stream<MessageStoreEntry> stream = this.entries.stream();
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Stream<MessageStoreEntry> stream(Index index, String value) {
        String indexKey = this.indexKeyOf(index, value);
        if (this.indexes.containsKey(indexKey)) {
            return ((Deque)this.indexes.get(indexKey)).stream();
        }
        return Stream.empty();
    }

    @Override
    public long size() {
        return this.entries.size();
    }

    private String indexKeyOf(Index index, String value) {
        return index.getName() + "#" + value;
    }
}

