/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint;

import com.google.common.collect.ImmutableList;
import de.otto.synapse.endpoint.EndpointType;
import de.otto.synapse.endpoint.InterceptorChain;
import de.otto.synapse.endpoint.MessageInterceptor;
import de.otto.synapse.endpoint.MessageInterceptorRegistration;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.core.OrderComparator;

public class MessageInterceptorRegistry {
    private static final Comparator<Object> REGISTRATION_ORDER_COMPARATOR = new OrderComparator().reversed();
    private final List<MessageInterceptorRegistration> registry = Collections.synchronizedList(new ArrayList());
    private final ConcurrentMap<String, InterceptorChain> interceptorChainCache = new ConcurrentHashMap<String, InterceptorChain>();

    public void register(@Nonnull MessageInterceptorRegistration registration) {
        this.registry.add(registration);
        this.registry.sort(REGISTRATION_ORDER_COMPARATOR);
        this.interceptorChainCache.clear();
    }

    @Nonnull
    public InterceptorChain getInterceptorChain(String channelName, EndpointType endpointType) {
        return this.interceptorChainCache.computeIfAbsent(channelName + "#" + endpointType.name(), key -> new InterceptorChain((ImmutableList<MessageInterceptor>)((ImmutableList)this.getRegistrations(channelName, endpointType).stream().map(MessageInterceptorRegistration::getInterceptor).collect(ImmutableList.toImmutableList()))));
    }

    @Nonnull
    public ImmutableList<MessageInterceptorRegistration> getRegistrations(String channelName, EndpointType endpointType) {
        return (ImmutableList)this.registry.stream().filter(registration -> registration.isEnabledFor(channelName, endpointType)).collect(ImmutableList.toImmutableList());
    }
}

