/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.consumer;

import de.otto.synapse.consumer.MessageConsumer;
import de.otto.synapse.message.Message;
import de.otto.synapse.state.StateRepository;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;

public class StatefulMessageConsumer<P, S>
implements MessageConsumer<P> {
    private final Pattern keyPattern;
    private final StateRepository<S> stateRepository;
    private final Class<P> payloadType;
    private final Function<? super Message<P>, String> keyMapper;
    private final BiFunction<Optional<S>, ? super Message<P>, S> payloadToStateMapper;

    public StatefulMessageConsumer(String keyPattern, Class<P> payloadType, StateRepository<S> stateRepository, Function<Message<P>, S> payloadToStateMapper) {
        this(keyPattern, payloadType, stateRepository, payloadToStateMapper, (? super Message<P> message) -> message.getKey().partitionKey());
    }

    public StatefulMessageConsumer(String keyPattern, Class<P> payloadType, StateRepository<S> stateRepository, BiFunction<Optional<S>, Message<P>, S> payloadToStateMapper) {
        this(keyPattern, payloadType, stateRepository, payloadToStateMapper, (? super Message<P> message) -> message.getKey().partitionKey());
    }

    public StatefulMessageConsumer(String keyPattern, Class<P> payloadType, StateRepository<S> stateRepository, Function<? super Message<P>, S> payloadToStateMapper, Function<? super Message<P>, String> keyMapper) {
        this.keyPattern = Pattern.compile(keyPattern);
        this.payloadType = payloadType;
        this.stateRepository = stateRepository;
        this.payloadToStateMapper = (_previousValue, message) -> payloadToStateMapper.apply((Object)message);
        this.keyMapper = keyMapper;
    }

    public StatefulMessageConsumer(String keyPattern, Class<P> payloadType, StateRepository<S> stateRepository, BiFunction<Optional<S>, ? super Message<P>, S> payloadToStateMapper, Function<? super Message<P>, String> keyMapper) {
        this.keyPattern = Pattern.compile(keyPattern);
        this.payloadType = payloadType;
        this.stateRepository = stateRepository;
        this.payloadToStateMapper = payloadToStateMapper;
        this.keyMapper = keyMapper;
    }

    @Override
    @Nonnull
    public Class<P> payloadType() {
        return this.payloadType;
    }

    @Override
    @Nonnull
    public Pattern keyPattern() {
        return this.keyPattern;
    }

    @Override
    public void accept(Message<P> message) {
        if (message.getPayload() == null) {
            this.stateRepository.remove(this.keyMapper.apply(message));
        } else {
            this.stateRepository.compute(this.keyMapper.apply(message), (_key, previousValue) -> this.payloadToStateMapper.apply((Optional<S>)previousValue, message));
        }
    }
}

