/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.info;

import de.otto.synapse.info.SnapshotReaderStatus;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.Objects;

public class SnapshotReaderNotification {
    private String channelName;
    private SnapshotReaderStatus status;
    private String message;
    private Instant snapshotTimestamp;

    protected SnapshotReaderNotification(Builder builder) {
        this.channelName = Objects.requireNonNull(builder.channelName);
        this.status = Objects.requireNonNull(builder.status);
        this.message = Objects.requireNonNull(builder.message);
        this.snapshotTimestamp = builder.snapshotTimestamp;
    }

    @Nonnull
    public String getChannelName() {
        return this.channelName;
    }

    @Nonnull
    public SnapshotReaderStatus getStatus() {
        return this.status;
    }

    @Nonnull
    public String getMessage() {
        return this.message;
    }

    @Nullable
    public Instant getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotReaderNotification that = (SnapshotReaderNotification)o;
        return Objects.equals(this.channelName, that.channelName) && this.status == that.status && Objects.equals(this.message, that.message) && Objects.equals(this.snapshotTimestamp, that.snapshotTimestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.channelName, this.status, this.message, this.snapshotTimestamp});
    }

    public String toString() {
        return "SnapshotReaderNotification{channelName='" + this.channelName + "', status=" + this.status + ", message='" + this.message + "', snapshotTimestamp=" + this.snapshotTimestamp + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SnapshotReaderNotification copy) {
        Builder builder = new Builder();
        builder.channelName = copy.getChannelName();
        builder.status = copy.getStatus();
        return builder;
    }

    public static class Builder {
        private String channelName = "";
        private SnapshotReaderStatus status;
        private String message = "";
        private Instant snapshotTimestamp;

        protected Builder() {
        }

        public Builder withChannelName(String val) {
            this.channelName = val;
            return this;
        }

        public Builder withStatus(SnapshotReaderStatus val) {
            this.status = val;
            return this;
        }

        public Builder withMessage(String msg) {
            this.message = msg;
            return this;
        }

        public Builder withSnapshotTimestamp(Instant snapshotTimestamp) {
            this.snapshotTimestamp = snapshotTimestamp;
            return this;
        }

        public SnapshotReaderNotification build() {
            return new SnapshotReaderNotification(this);
        }
    }
}

