/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.message;

import de.otto.synapse.message.CompoundKey;
import de.otto.synapse.message.SimpleKey;
import jakarta.annotation.Nonnull;
import java.io.Serializable;

public interface Key
extends Serializable {
    public static final Key NO_KEY = Key.of("nil");

    public static Key of() {
        return NO_KEY;
    }

    public static Key of(@Nonnull String key) {
        return !key.isEmpty() ? new SimpleKey(key) : NO_KEY;
    }

    public static Key of(@Nonnull String partitionKey, @Nonnull String compactionKey) {
        return partitionKey.equals(compactionKey) ? new SimpleKey(partitionKey) : new CompoundKey(partitionKey, compactionKey);
    }

    @Nonnull
    public String partitionKey();

    @Nonnull
    public String compactionKey();

    public boolean isCompoundKey();
}

