/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore;

import com.google.common.collect.ImmutableSet;
import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.messagestore.Index;
import de.otto.synapse.messagestore.MessageStore;
import de.otto.synapse.messagestore.MessageStoreEntry;
import de.otto.synapse.messagestore.SnapshotMessageStore;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.Set;
import java.util.stream.Stream;

public class DelegatingSnapshotMessageStore
implements SnapshotMessageStore {
    private final MessageStore delegate;

    public DelegatingSnapshotMessageStore(MessageStore delegate) {
        this.delegate = delegate;
    }

    @Override
    public Instant getSnapshotTimestamp() {
        return this.delegate instanceof SnapshotMessageStore ? ((SnapshotMessageStore)this.delegate).getSnapshotTimestamp() : Instant.now();
    }

    @Override
    public Set<String> getChannelNames() {
        return this.delegate.getChannelNames();
    }

    @Override
    public ImmutableSet<Index> getIndexes() {
        return this.delegate.getIndexes();
    }

    @Override
    public ChannelPosition getLatestChannelPosition(String channelName) {
        return this.delegate.getLatestChannelPosition(channelName);
    }

    @Override
    @Deprecated
    public ChannelPosition getLatestChannelPosition() {
        return this.delegate.getLatestChannelPosition();
    }

    @Override
    public Stream<MessageStoreEntry> stream() {
        return this.delegate.stream();
    }

    @Override
    public Stream<MessageStoreEntry> stream(Index index, String value) {
        return this.delegate.stream(index, value);
    }

    @Override
    @Deprecated
    public void add(@Nonnull MessageStoreEntry entry) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long size() {
        return this.delegate.size();
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

